/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor;

import java.util.stream.Collectors;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.remote.RemoteNode;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.Tracer;

class AddNode
implements HttpHandler {
    private final Tracer tracer;
    private final Distributor distributor;
    private final Json json;
    private final HttpClient.Factory httpFactory;
    private final Secret registrationSecret;

    AddNode(Tracer tracer, Distributor distributor, Json json, HttpClient.Factory httpFactory, Secret registrationSecret) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.distributor = (Distributor)Require.nonNull((String)"Distributor", (Object)distributor);
        this.json = (Json)Require.nonNull((String)"Json converter", (Object)json);
        this.httpFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP Factory", (Object)httpFactory);
        this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
    }

    public HttpResponse execute(HttpRequest req) {
        NodeStatus status = (NodeStatus)this.json.toType(Contents.string((HttpMessage)req), NodeStatus.class);
        RemoteNode node = new RemoteNode(this.tracer, this.httpFactory, status.getNodeId(), status.getExternalUri(), this.registrationSecret, status.getSlots().stream().map(Slot::getStereotype).collect(Collectors.toSet()));
        this.distributor.add(node);
        return new HttpResponse();
    }
}

