/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.devtools.CdpEndpointFinder;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.UrlTemplate;
import org.openqa.selenium.remote.http.WebSocket;

public class ProxyNodeWebsockets
implements BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> {
    private static final UrlTemplate CDP_TEMPLATE = new UrlTemplate("/session/{sessionId}/se/cdp");
    private static final UrlTemplate BIDI_TEMPLATE = new UrlTemplate("/session/{sessionId}/se/bidi");
    private static final UrlTemplate FWD_TEMPLATE = new UrlTemplate("/session/{sessionId}/se/fwd");
    private static final UrlTemplate VNC_TEMPLATE = new UrlTemplate("/session/{sessionId}/se/vnc");
    private static final Logger LOG = Logger.getLogger(ProxyNodeWebsockets.class.getName());
    private static final ImmutableSet<String> CDP_ENDPOINT_CAPS = ImmutableSet.of((Object)"goog:chromeOptions", (Object)"moz:debuggerAddress", (Object)"ms:edgeOptions");
    private final HttpClient.Factory clientFactory;
    private final Node node;

    public ProxyNodeWebsockets(HttpClient.Factory clientFactory, Node node) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.node = Objects.requireNonNull(node);
    }

    @Override
    public Optional<Consumer<Message>> apply(String uri, Consumer<Message> downstream) {
        UrlTemplate.Match fwdMatch = FWD_TEMPLATE.match(uri);
        UrlTemplate.Match cdpMatch = CDP_TEMPLATE.match(uri);
        UrlTemplate.Match bidiMatch = BIDI_TEMPLATE.match(uri);
        UrlTemplate.Match vncMatch = VNC_TEMPLATE.match(uri);
        if (cdpMatch == null && vncMatch == null && fwdMatch == null) {
            return Optional.empty();
        }
        String sessionId = (String)Stream.of(fwdMatch, cdpMatch, bidiMatch, vncMatch).filter(Objects::nonNull).findFirst().get().getParameters().get("sessionId");
        LOG.fine("Matching websockets for session id: " + sessionId);
        SessionId id = new SessionId(sessionId);
        if (!this.node.isSessionOwner(id)) {
            LOG.info("Not owner of " + id);
            return Optional.empty();
        }
        Session session = this.node.getSession(id);
        Capabilities caps = session.getCapabilities();
        LOG.fine("Scanning for endpoint: " + caps);
        if (bidiMatch != null) {
            return this.findBiDiEndpoint(downstream, caps);
        }
        if (vncMatch != null) {
            return this.findVncEndpoint(downstream, caps);
        }
        if (fwdMatch != null) {
            LOG.info("Matched endpoint where CDP connection is being forwarded");
            return this.findCdpEndpoint(downstream, caps);
        }
        if (caps.getCapabilityNames().contains("se:forwardCdp")) {
            LOG.info("Found endpoint where CDP connection needs to be forwarded");
            return this.findForwardCdpEndpoint(downstream, caps);
        }
        return this.findCdpEndpoint(downstream, caps);
    }

    private Optional<Consumer<Message>> findCdpEndpoint(Consumer<Message> downstream, Capabilities caps) {
        for (String cdpEndpointCap : CDP_ENDPOINT_CAPS) {
            Optional<Consumer> cdpUri = CdpEndpointFinder.getReportedUri((String)cdpEndpointCap, (Capabilities)caps).flatMap(reported -> CdpEndpointFinder.getCdpEndPoint((HttpClient.Factory)this.clientFactory, (URI)reported));
            if (!cdpUri.isPresent()) continue;
            LOG.log(Debug.getDebugLogLevel(), String.format("Endpoint found in %s", cdpEndpointCap));
            return cdpUri.map(cdp -> this.createWsEndPoint((URI)cdp, downstream));
        }
        return Optional.empty();
    }

    private Optional<Consumer<Message>> findBiDiEndpoint(Consumer<Message> downstream, Capabilities caps) {
        try {
            URI uri = new URI(String.valueOf(caps.getCapability("webSocketUrl")));
            return Optional.of(uri).map(bidi -> this.createWsEndPoint((URI)bidi, downstream));
        }
        catch (URISyntaxException e) {
            LOG.warning("Unable to create URI from: " + caps.getCapability(""));
            return Optional.empty();
        }
    }

    private Optional<Consumer<Message>> findForwardCdpEndpoint(Consumer<Message> downstream, Capabilities caps) {
        try {
            URI uri = new URI(String.valueOf(caps.getCapability("se:forwardCdp")));
            return Optional.of(uri).map(cdp -> this.createWsEndPoint((URI)cdp, downstream));
        }
        catch (URISyntaxException e) {
            LOG.warning("Unable to create URI from: " + caps.getCapability("se:forwardCdp"));
            return Optional.empty();
        }
    }

    private Optional<Consumer<Message>> findVncEndpoint(Consumer<Message> downstream, Capabilities caps) {
        Optional<URI> vncUri;
        String vncLocalAddress = (String)caps.getCapability("se:vncLocalAddress");
        try {
            vncUri = Optional.of(new URI(vncLocalAddress));
        }
        catch (URISyntaxException e) {
            LOG.warning("Invalid URI for endpoint " + vncLocalAddress);
            return Optional.empty();
        }
        LOG.log(Debug.getDebugLogLevel(), String.format("Endpoint found in %s", "se:vncLocalAddress"));
        return vncUri.map(vnc -> this.createWsEndPoint((URI)vnc, downstream));
    }

    private Consumer<Message> createWsEndPoint(URI uri, Consumer<Message> downstream) {
        Objects.requireNonNull(uri);
        LOG.info("Establishing connection to " + uri);
        HttpClient client = this.clientFactory.createClient(ClientConfig.defaultConfig().baseUri(uri));
        WebSocket upstream = client.openSocket(new HttpRequest(HttpMethod.GET, uri.toString()), (WebSocket.Listener)new ForwardingListener(downstream));
        return arg_0 -> ((WebSocket)upstream).send(arg_0);
    }

    private static class ForwardingListener
    implements WebSocket.Listener {
        private final Consumer<Message> downstream;

        public ForwardingListener(Consumer<Message> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        public void onBinary(byte[] data) {
            this.downstream.accept((Message)new BinaryMessage(data));
        }

        public void onClose(int code, String reason) {
            this.downstream.accept((Message)new CloseMessage(code, reason));
        }

        public void onText(CharSequence data) {
            this.downstream.accept((Message)new TextMessage(data));
        }

        public void onError(Throwable cause) {
            LOG.log(Level.WARNING, "Error proxying websocket command", cause);
        }
    }
}

