/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;

public class MergedResource
implements Resource {
    private final Resource base;
    private final Optional<Resource> next;

    public MergedResource(Resource base) {
        this(base, null);
    }

    private MergedResource(Resource base, Resource next) {
        this.base = (Resource)Require.nonNull((String)"Base resource", (Object)base);
        this.next = Optional.ofNullable(next);
    }

    public MergedResource alsoCheck(Resource resource) {
        return new MergedResource(this, (Resource)Require.nonNull((String)"Resource", (Object)resource));
    }

    @Override
    public String name() {
        return this.base.name();
    }

    @Override
    public Optional<Resource> get(String path) {
        Optional<Resource> resource = this.base.get(path);
        if (resource.isPresent()) {
            return resource;
        }
        if (!this.next.isPresent()) {
            return Optional.empty();
        }
        return this.next.get().get(path);
    }

    @Override
    public boolean isDirectory() {
        return this.base.isDirectory() || this.next.map(Resource::isDirectory).orElse(false) != false;
    }

    @Override
    public Set<Resource> list() {
        ImmutableSet.Builder resources = ImmutableSet.builder();
        resources.addAll(this.base.list());
        this.next.ifPresent(res -> resources.addAll(res.list()));
        return resources.build();
    }

    @Override
    public Optional<byte[]> read() {
        Optional<byte[]> data = this.base.read();
        if (data.isPresent()) {
            return data;
        }
        if (!this.next.isPresent()) {
            return Optional.empty();
        }
        return this.next.get().read();
    }
}

