/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.commands.DefaultStandaloneConfig;
import org.openqa.selenium.grid.commands.StandaloneFlags;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.ProxyNodeWebsockets;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.router.httpd.RouterOptions;
import org.openqa.selenium.grid.security.BasicAuthenticationFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.GridUiRoute;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class Standalone
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger("selenium");

    @Override
    public String getName() {
        return "standalone";
    }

    @Override
    public String getDescription() {
        return "The selenium server, running everything in-process.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.DISTRIBUTOR_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.NODE_ROLE, (Object)StandardGridRoles.ROUTER_ROLE, (Object)StandardGridRoles.SESSION_QUEUE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.singleton(new StandaloneFlags());
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "selenium";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultStandaloneConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        Routable httpHandler;
        URL localhostUrl;
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        URI localhost = serverOptions.getExternalUri();
        try {
            localhostUrl = localhost.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        NetworkOptions networkOptions = new NetworkOptions(config);
        CombinedHandler combinedHandler = new CombinedHandler();
        RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(localhostUrl, combinedHandler, networkOptions.getHttpClientFactory(tracer));
        LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
        combinedHandler.addHandler(sessions);
        DistributorOptions distributorOptions = new DistributorOptions(config);
        NewSessionQueueOptions newSessionRequestOptions = new NewSessionQueueOptions(config);
        final LocalNewSessionQueue queue = new LocalNewSessionQueue(tracer, distributorOptions.getSlotMatcher(), newSessionRequestOptions.getSessionRequestTimeoutPeriod(), newSessionRequestOptions.getSessionRequestTimeout(), registrationSecret, newSessionRequestOptions.getBatchSize());
        combinedHandler.addHandler(queue);
        final LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, queue, distributorOptions.getSlotSelector(), registrationSecret, distributorOptions.getHealthCheckInterval(), distributorOptions.shouldRejectUnsupportedCaps(), newSessionRequestOptions.getSessionRequestRetryInterval(), distributorOptions.getNewSessionThreadPoolSize(), distributorOptions.getSlotMatcher());
        combinedHandler.addHandler(distributor);
        final Router router = new Router(tracer, clientFactory, sessions, queue, distributor);
        Routable routerWithSpecChecks = router.with(networkOptions.getSpecComplianceChecks());
        HttpHandler readinessCheck = req -> {
            boolean ready = sessions.isReady() && distributor.isReady() && bus.isReady();
            return (HttpResponse)new HttpResponse().setStatus(ready ? 200 : 503).setContent(Contents.utf8String((CharSequence)("Standalone is " + ready)));
        };
        GraphqlHandler graphqlHandler = new GraphqlHandler(tracer, distributor, queue, serverOptions.getExternalUri(), this.getFormattedVersion());
        RouterOptions routerOptions = new RouterOptions(config);
        String subPath = routerOptions.subPath();
        Routable appendRoute = Stream.of(Standalone.baseRoute(subPath, Route.combine((Routable)routerWithSpecChecks, (Routable[])new Routable[0])), Standalone.hubRoute(subPath, Route.combine((Routable)routerWithSpecChecks, (Routable[])new Routable[0])), Standalone.graphqlRoute(subPath, () -> graphqlHandler)).reduce((x$0, xva$1) -> Route.combine((Routable)x$0, (Routable[])new Routable[]{xva$1})).get();
        if (routerOptions.disableUi()) {
            LOG.info("Grid UI has been disabled.");
            httpHandler = appendRoute;
        } else {
            GridUiRoute ui = new GridUiRoute(subPath);
            httpHandler = Route.combine((Routable)ui, (Routable[])new Routable[]{appendRoute});
        }
        UsernameAndPassword uap = secretOptions.getServerAuthentication();
        if (uap != null) {
            LOG.info("Requiring authentication to connect");
            httpHandler = httpHandler.with((Filter)new BasicAuthenticationFilter(uap.username(), uap.password()));
        }
        httpHandler = Route.combine((Routable)httpHandler, (Routable[])new Routable[]{Route.get((String)"/readyz").to(() -> readinessCheck)});
        Node node = this.createNode(config, bus, distributor, combinedHandler);
        return new TemplateGridServerCommand.Handlers((HttpHandler)httpHandler, new ProxyNodeWebsockets(clientFactory, node, subPath)){

            @Override
            public void close() {
                router.close();
                distributor.close();
                queue.close();
            }
        };
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        config.get("server", "max-threads").ifPresent(value -> LOG.log(Level.WARNING, () -> "Support for max-threads flag is deprecated. The intent of the flag is to set the thread pool size in the Distributor. Please use newsession-threadpool-size flag instead."));
        Server server = (Server)this.asServer(config).start();
        LOG.info(String.format("Started Selenium Standalone %s: %s", this.getFormattedVersion(), server.getUrl()));
    }

    private String getFormattedVersion() {
        BuildInfo info = new BuildInfo();
        return String.format("%s (revision %s)", info.getReleaseLabel(), info.getBuildRevision());
    }

    private Node createNode(Config config, EventBus bus, Distributor distributor, CombinedHandler combinedHandler) {
        Node node = new NodeOptions(config).getNode();
        combinedHandler.addHandler(node);
        distributor.add(node);
        bus.addListener(NodeDrainComplete.listener(nodeId -> {
            if (!node.getId().equals(nodeId)) {
                return;
            }
            new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LOG.info("Shutting down");
                System.exit(0);
            }, "Standalone shutdown: " + String.valueOf(nodeId)).start();
        }));
        return node;
    }
}

