/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.PersistentCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeDrainStarted;
import org.openqa.selenium.grid.data.NodeHeartBeatEvent;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.CapabilityResponseEncoder;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.docker.DockerSession;
import org.openqa.selenium.grid.node.local.SessionSlot;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.io.FileHandler;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.Browser;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tracer;

@ManagedService(objectName="org.seleniumhq.grid:type=Node,name=LocalNode", description="Node running the webdriver sessions.")
public class LocalNode
extends Node {
    private static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger(LocalNode.class.getName());
    private final EventBus bus;
    private final URI externalUri;
    private final URI gridUri;
    private final Duration heartbeatPeriod;
    private final HealthCheck healthCheck;
    private final int maxSessionCount;
    private final int configuredSessionCount;
    private final boolean cdpEnabled;
    private final boolean managedDownloadsEnabled;
    private final int connectionLimitPerSession;
    private final boolean bidiEnabled;
    private final AtomicBoolean drainAfterSessions = new AtomicBoolean();
    private final List<SessionSlot> factories;
    private final Cache<SessionId, SessionSlot> currentSessions;
    private final Cache<SessionId, TemporaryFilesystem> uploadsTempFileSystem;
    private final Cache<UUID, TemporaryFilesystem> downloadsTempFileSystem;
    private final Cache<SessionId, UUID> sessionToDownloadsDir;
    private final AtomicInteger pendingSessions = new AtomicInteger();
    private final AtomicInteger sessionCount = new AtomicInteger();

    protected LocalNode(Tracer tracer, EventBus bus, URI uri, URI gridUri, HealthCheck healthCheck, int maxSessionCount, int drainAfterSessionCount, boolean cdpEnabled, boolean bidiEnabled, Ticker ticker, Duration sessionTimeout, Duration heartbeatPeriod, List<SessionSlot> factories, Secret registrationSecret, boolean managedDownloadsEnabled, int connectionLimitPerSession) {
        super(tracer, new NodeId(UUID.randomUUID()), uri, registrationSecret, Require.positive((Duration)sessionTimeout));
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.externalUri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
        this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
        this.maxSessionCount = Math.min(Require.positive((String)"Max session count", (Integer)maxSessionCount), factories.size());
        this.heartbeatPeriod = heartbeatPeriod;
        this.factories = ImmutableList.copyOf(factories);
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.configuredSessionCount = drainAfterSessionCount;
        this.drainAfterSessions.set(this.configuredSessionCount > 0);
        this.sessionCount.set(drainAfterSessionCount);
        this.cdpEnabled = cdpEnabled;
        this.bidiEnabled = bidiEnabled;
        this.managedDownloadsEnabled = managedDownloadsEnabled;
        this.connectionLimitPerSession = connectionLimitPerSession;
        this.healthCheck = healthCheck == null ? () -> {
            NodeStatus status = this.getStatus();
            return new HealthCheck.Result(status.getAvailability(), String.format("%s is %s", new Object[]{uri, status.getAvailability()}));
        } : healthCheck;
        this.uploadsTempFileSystem = CacheBuilder.newBuilder().removalListener(notification -> Optional.ofNullable((TemporaryFilesystem)notification.getValue()).ifPresent(tempFS -> {
            tempFS.deleteTemporaryFiles();
            tempFS.deleteBaseDir();
        })).build();
        this.downloadsTempFileSystem = CacheBuilder.newBuilder().removalListener(notification -> Optional.ofNullable((TemporaryFilesystem)notification.getValue()).ifPresent(fs -> {
            fs.deleteTemporaryFiles();
            fs.deleteBaseDir();
        })).build();
        this.sessionToDownloadsDir = CacheBuilder.newBuilder().removalListener(notification -> {
            Optional.ofNullable((UUID)notification.getValue()).ifPresent(value -> {
                this.downloadsTempFileSystem.invalidate(value);
                LOG.fine("Removing Downloads folder associated with " + String.valueOf(notification.getKey()));
            });
            Optional.ofNullable((SessionId)notification.getKey()).ifPresent(value -> {
                this.uploadsTempFileSystem.invalidate(value);
                LOG.fine("Removing Uploads folder associated with " + String.valueOf(notification.getKey()));
            });
        }).build();
        this.currentSessions = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(this::stopTimedOutSession).build();
        ScheduledExecutorService sessionCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("Local Node - Session Cleanup " + String.valueOf(this.externalUri));
            return thread;
        });
        sessionCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.currentSessions.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService uploadTempFileCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("UploadTempFile Cleanup Node " + String.valueOf(this.externalUri));
            return thread;
        });
        uploadTempFileCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.uploadsTempFileSystem.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService downloadTempFileCleanupNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("DownloadTempFile Cleanup Node " + String.valueOf(this.externalUri));
            return thread;
        });
        downloadTempFileCleanupNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> this.downloadsTempFileSystem.cleanUp()), 30L, 30L, TimeUnit.SECONDS);
        ScheduledExecutorService heartbeatNodeService = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName("HeartBeat Node " + String.valueOf(this.externalUri));
            return thread;
        });
        heartbeatNodeService.scheduleAtFixedRate(GuardedRunnable.guard(() -> bus.fire(new NodeHeartBeatEvent(this.getStatus()))), heartbeatPeriod.getSeconds(), heartbeatPeriod.getSeconds(), TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.stopAllSessions();
            this.drain();
        }));
        new JMXHelper().register(this);
    }

    private void stopTimedOutSession(RemovalNotification<SessionId, SessionSlot> notification) {
        if (notification.getKey() != null && notification.getValue() != null) {
            int done;
            SessionSlot slot = (SessionSlot)notification.getValue();
            SessionId id = (SessionId)notification.getKey();
            if (notification.wasEvicted()) {
                LOG.log(Level.INFO, () -> String.format("Session id %s timed out, stopping...", id));
                try {
                    slot.execute(new HttpRequest(HttpMethod.DELETE, "/session/" + String.valueOf(id)));
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, String.format("Exception while trying to stop session %s", id), e);
                }
            }
            slot.stop();
            if (this.isDraining() && (done = this.pendingSessions.decrementAndGet()) <= 0) {
                LOG.info("Node draining complete!");
                this.bus.fire(new NodeDrainComplete(this.getId()));
            }
        } else {
            LOG.log(Debug.getDebugLogLevel(), "Received stop session notification with null values");
        }
    }

    public static Builder builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
        return new Builder(tracer, bus, uri, gridUri, registrationSecret);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @ManagedAttribute(name="CurrentSessions")
    @VisibleForTesting
    public int getCurrentSessionCount() {
        return Math.toIntExact(this.currentSessions.size());
    }

    @VisibleForTesting
    public UUID getDownloadsIdForSession(SessionId id) {
        UUID uuid = (UUID)this.sessionToDownloadsDir.getIfPresent((Object)id);
        if (uuid == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        return uuid;
    }

    @ManagedAttribute(name="MaxSessions")
    public int getMaxSessionCount() {
        return this.maxSessionCount;
    }

    @ManagedAttribute(name="Status")
    public Availability getAvailability() {
        return this.isDraining() ? Availability.DRAINING : Availability.UP;
    }

    @ManagedAttribute(name="TotalSlots")
    public int getTotalSlots() {
        return this.factories.size();
    }

    @ManagedAttribute(name="UsedSlots")
    public long getUsedSlots() {
        return this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
    }

    @ManagedAttribute(name="Load")
    public float getLoad() {
        long inUse = this.factories.stream().filter(sessionSlot -> !sessionSlot.isAvailable()).count();
        return (float)inUse / (float)this.maxSessionCount * 100.0f;
    }

    @ManagedAttribute(name="RemoteNodeUri")
    public URI getExternalUri() {
        return this.getUri();
    }

    @ManagedAttribute(name="GridUri")
    public URI getGridUri() {
        return this.gridUri;
    }

    @ManagedAttribute(name="NodeId")
    public String getNodeId() {
        return this.getId().toString();
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.parallelStream().anyMatch(factory -> factory.test(capabilities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Require.nonNull((String)"Session request", (Object)sessionRequest);
        try {
            Either either;
            block30: {
                Either<WebDriverException, ActiveSession> possibleSession;
                SessionSlot slotToUse;
                AttributeMap attributeMap;
                Span span;
                block28: {
                    Either either2;
                    block29: {
                        block26: {
                            Either either3;
                            block27: {
                                block24: {
                                    Either either4;
                                    block25: {
                                        block22: {
                                            Either either5;
                                            block23: {
                                                span = this.tracer.getCurrentContext().createSpan("node.new_session");
                                                attributeMap = this.tracer.createAttributeMap();
                                                attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
                                                attributeMap.put("session.request.capabilities", sessionRequest.getDesiredCapabilities().toString());
                                                attributeMap.put("session.request.downstreamdialect", sessionRequest.getDownstreamDialects().toString());
                                                int currentSessionCount = this.getCurrentSessionCount();
                                                span.setAttribute("current.session.count", (Number)currentSessionCount);
                                                attributeMap.put("current.session.count", (long)currentSessionCount);
                                                if (this.getCurrentSessionCount() < this.maxSessionCount) break block22;
                                                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                                                span.setStatus(Status.RESOURCE_EXHAUSTED);
                                                attributeMap.put("max.session.count", (long)this.maxSessionCount);
                                                span.addEvent("Max session count reached", attributeMap);
                                                either5 = Either.left((Object)new RetrySessionRequestException("Max session count reached."));
                                                if (span == null) break block23;
                                                span.close();
                                            }
                                            return either5;
                                        }
                                        if (!this.isDraining()) break block24;
                                        span.setStatus(Status.UNAVAILABLE.withDescription("The node is draining. Cannot accept new sessions."));
                                        either4 = Either.left((Object)new RetrySessionRequestException("The node is draining. Cannot accept new sessions."));
                                        if (span == null) break block25;
                                        span.close();
                                    }
                                    return either4;
                                }
                                try {
                                    slotToUse = null;
                                    either3 = this.factories;
                                    synchronized (either3) {
                                        for (SessionSlot factory : this.factories) {
                                            if (!factory.isAvailable() || !factory.test(sessionRequest.getDesiredCapabilities())) continue;
                                            factory.reserve();
                                            slotToUse = factory;
                                            break;
                                        }
                                    }
                                    if (slotToUse != null) break block26;
                                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                                    span.setStatus(Status.NOT_FOUND);
                                    span.addEvent("No slot matched the requested capabilities. ", attributeMap);
                                    either3 = Either.left((Object)new RetrySessionRequestException("No slot matched the requested capabilities."));
                                    if (span == null) break block27;
                                }
                                catch (Throwable throwable) {
                                    if (span != null) {
                                        try {
                                            span.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                span.close();
                            }
                            return either3;
                        }
                        UUID uuidForSessionDownloads = UUID.randomUUID();
                        Capabilities desiredCapabilities = sessionRequest.getDesiredCapabilities();
                        if (this.managedDownloadsRequested(desiredCapabilities)) {
                            Capabilities enhanced = this.setDownloadsDirectory(uuidForSessionDownloads, desiredCapabilities);
                            enhanced = desiredCapabilities.merge(enhanced);
                            sessionRequest = new CreateSessionRequest(sessionRequest.getDownstreamDialects(), enhanced, sessionRequest.getMetadata());
                        }
                        if (!(possibleSession = slotToUse.apply(sessionRequest)).isRight()) break block28;
                        ActiveSession session = (ActiveSession)possibleSession.right();
                        this.sessionToDownloadsDir.put((Object)session.getId(), (Object)uuidForSessionDownloads);
                        this.currentSessions.put((Object)session.getId(), (Object)slotToUse);
                        SessionId sessionId = session.getId();
                        Capabilities caps = session.getCapabilities();
                        RemoteTags.SESSION_ID.accept(span, sessionId);
                        RemoteTags.CAPABILITIES.accept(span, caps);
                        String downstream = session.getDownstreamDialect().toString();
                        String upstream = session.getUpstreamDialect().toString();
                        String sessionUri = session.getUri().toString();
                        span.setAttribute(AttributeKey.DOWNSTREAM_DIALECT.getKey(), downstream);
                        span.setAttribute(AttributeKey.UPSTREAM_DIALECT.getKey(), upstream);
                        span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                        Session externalSession = this.createExternalSession(session, this.externalUri, slotToUse.isSupportingCdp(), slotToUse.isSupportingBiDi(), desiredCapabilities);
                        String sessionCreatedMessage = "Session created by the Node";
                        LOG.info(String.format("%s. Id: %s, Caps: %s", sessionCreatedMessage, sessionId, externalSession.getCapabilities()));
                        either2 = Either.right((Object)new CreateSessionResponse(externalSession, (byte[])CapabilityResponseEncoder.getEncoder(session.getDownstreamDialect()).apply(externalSession)));
                        if (span == null) break block29;
                        span.close();
                    }
                    return either2;
                }
                slotToUse.release();
                span.setAttribute(AttributeKey.ERROR.getKey(), true);
                span.setStatus(Status.ABORTED);
                span.addEvent("Unable to create session with the driver", attributeMap);
                either = Either.left((Object)((Object)((WebDriverException)((Object)possibleSession.left()))));
                if (span == null) break block30;
                span.close();
            }
            return either;
        }
        finally {
            this.checkSessionCount();
        }
    }

    private boolean managedDownloadsRequested(Capabilities capabilities) {
        Object downloadsEnabled = capabilities.getCapability("se:downloadsEnabled");
        return this.managedDownloadsEnabled && downloadsEnabled != null && Boolean.parseBoolean(downloadsEnabled.toString());
    }

    private Capabilities setDownloadsDirectory(UUID uuid, Capabilities caps) {
        ImmutableMap map;
        File tempDir;
        try {
            TemporaryFilesystem tempFS = this.getDownloadsFilesystem(uuid);
            tempDir = tempFS.createTempDir("download", "");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (Browser.CHROME.is(caps) || Browser.EDGE.is(caps)) {
            map = ImmutableMap.of((Object)"download.prompt_for_download", (Object)false, (Object)"download.default_directory", (Object)tempDir.getAbsolutePath(), (Object)"savefile.default_directory", (Object)tempDir.getAbsolutePath());
            String optionsKey = Browser.CHROME.is(caps) ? "goog:chromeOptions" : "ms:edgeOptions";
            return this.appendPrefs(caps, optionsKey, (Map<String, Serializable>)map);
        }
        if (Browser.FIREFOX.is(caps)) {
            map = ImmutableMap.of((Object)"browser.download.folderList", (Object)2, (Object)"browser.download.dir", (Object)tempDir.getAbsolutePath());
            return this.appendPrefs(caps, "moz:firefoxOptions", (Map<String, Serializable>)map);
        }
        return caps;
    }

    private Capabilities appendPrefs(Capabilities caps, String optionsKey, Map<String, Serializable> map) {
        if (caps.getCapability(optionsKey) == null) {
            MutableCapabilities mutableCaps = new MutableCapabilities();
            mutableCaps.setCapability(optionsKey, new HashMap());
            caps = caps.merge((Capabilities)mutableCaps);
        }
        Map currentOptions = (Map)caps.getCapability(optionsKey);
        ((Map)currentOptions.computeIfAbsent("prefs", k -> new HashMap())).putAll(map);
        return caps;
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        return this.currentSessions.getIfPresent((Object)id) != null;
    }

    @Override
    public boolean tryAcquireConnection(SessionId id) throws NoSuchSessionException {
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            return false;
        }
        if (this.connectionLimitPerSession == -1) {
            return true;
        }
        AtomicLong counter = slot.getConnectionCounter();
        return (long)this.connectionLimitPerSession > counter.getAndIncrement();
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        return this.createExternalSession(slot.getSession(), this.externalUri, slot.isSupportingCdp(), slot.isSupportingBiDi(), slot.getSession().getCapabilities());
    }

    @Override
    public TemporaryFilesystem getUploadsFilesystem(SessionId id) throws IOException {
        try {
            return (TemporaryFilesystem)this.uploadsTempFileSystem.get((Object)id, () -> TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("session", id.toString())));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public TemporaryFilesystem getDownloadsFilesystem(UUID uuid) throws IOException {
        try {
            return (TemporaryFilesystem)this.downloadsTempFileSystem.get((Object)uuid, () -> TemporaryFilesystem.getTmpFsBasedOn((File)TemporaryFilesystem.getDefaultTmpFS().createTempDir("uuid", uuid.toString())));
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + String.valueOf(req)));
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        HttpResponse toReturn = slot.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && req.getUri().equals("/session/" + String.valueOf(id))) {
            this.stop(id);
        }
        return toReturn;
    }

    @Override
    public HttpResponse downloadFile(HttpRequest req, SessionId id) {
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot != null && slot.getSession() instanceof DockerSession) {
            return this.executeWebDriverCommand(req);
        }
        if (!this.managedDownloadsEnabled) {
            String msg = "Please enable management of downloads via the command line arg [--enable-managed-downloads] and restart the node";
            throw new WebDriverException(msg);
        }
        UUID uuid = (UUID)this.sessionToDownloadsDir.getIfPresent((Object)id);
        if (uuid == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        TemporaryFilesystem tempFS = (TemporaryFilesystem)this.downloadsTempFileSystem.getIfPresent((Object)uuid);
        if (tempFS == null) {
            String msg = "Cannot find downloads file system for session id: " + String.valueOf(id) + " \u2014 ensure downloads are enabled in the options class when requesting a session.";
            throw new WebDriverException(msg);
        }
        File downloadsDirectory = Optional.ofNullable(tempFS.getBaseDir().listFiles()).orElse(new File[0])[0];
        if (req.getMethod().equals((Object)HttpMethod.GET)) {
            List collected = Arrays.stream(Optional.ofNullable(downloadsDirectory.listFiles()).orElse(new File[0])).map(File::getName).collect(Collectors.toList());
            ImmutableMap data = ImmutableMap.of((Object)"names", collected);
            ImmutableMap result = ImmutableMap.of((Object)"value", (Object)data);
            return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)result));
        }
        if (req.getMethod().equals((Object)HttpMethod.DELETE)) {
            File[] files;
            for (File file : files = Optional.ofNullable(downloadsDirectory.listFiles()).orElse(new File[0])) {
                FileHandler.delete((File)file);
            }
            HashMap<String, Object> toReturn = new HashMap<String, Object>();
            toReturn.put("value", null);
            return (HttpResponse)new HttpResponse().setContent(Contents.asJson(toReturn));
        }
        String raw = Contents.string((HttpMessage)req);
        if (raw.isEmpty()) {
            throw new WebDriverException("Please specify file to download in payload as {\"name\": \"fileToDownload\"}");
        }
        Map incoming = (Map)JSON.toType(raw, Json.MAP_TYPE);
        String filename = Optional.ofNullable(incoming.get("name")).map(Object::toString).orElseThrow(() -> new WebDriverException("Please specify file to download in payload as {\"name\": \"fileToDownload\"}"));
        try {
            File[] allFiles = Optional.ofNullable(downloadsDirectory.listFiles((dir, name) -> name.equals(filename))).orElse(new File[0]);
            if (allFiles.length == 0) {
                throw new WebDriverException(String.format("Cannot find file [%s] in directory %s.", filename, downloadsDirectory.getAbsolutePath()));
            }
            if (allFiles.length != 1) {
                throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s.", allFiles.length));
            }
            String content = Zip.zip((File)allFiles[0]);
            ImmutableMap data = ImmutableMap.of((Object)"filename", (Object)filename, (Object)"contents", (Object)content);
            ImmutableMap result = ImmutableMap.of((Object)"value", (Object)data);
            return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)result));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        File tempDir;
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot != null && slot.getSession() instanceof DockerSession) {
            return this.executeWebDriverCommand(req);
        }
        Map incoming = (Map)JSON.toType(Contents.string((HttpMessage)req), Json.MAP_TYPE);
        try {
            TemporaryFilesystem tempFS = this.getUploadsFilesystem(id);
            tempDir = tempFS.createTempDir("upload", "file");
            Zip.unzip((String)((String)incoming.get("file")), (File)tempDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File[] allFiles = tempDir.listFiles();
        if (allFiles == null) {
            throw new WebDriverException(String.format("Cannot access temporary directory for uploaded files %s", tempDir));
        }
        if (allFiles.length != 1) {
            throw new WebDriverException(String.format("Expected there to be only 1 file. There were: %s", allFiles.length));
        }
        ImmutableMap result = ImmutableMap.of((Object)"value", (Object)allFiles[0].getAbsolutePath());
        return (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)result));
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        SessionSlot slot;
        Require.nonNull((String)"Session ID", (Object)id);
        if (this.sessionToDownloadsDir.getIfPresent((Object)id) != null) {
            this.sessionToDownloadsDir.invalidate((Object)id);
        }
        if ((slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id)) == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + String.valueOf(id));
        }
        this.currentSessions.invalidate((Object)id);
    }

    private void stopAllSessions() {
        if (this.currentSessions.size() > 0L) {
            LOG.info("Trying to stop all running sessions before shutting down...");
            this.currentSessions.invalidateAll();
        }
    }

    private Session createExternalSession(ActiveSession other, URI externalUri, boolean isSupportingCdp, boolean isSupportingBiDi, Capabilities requestCapabilities) {
        boolean isVncEnabled;
        boolean bidiSupported;
        ImmutableCapabilities toUse = ImmutableCapabilities.copyOf((Capabilities)requestCapabilities.merge(other.getCapabilities()));
        if ((isSupportingCdp || toUse.getCapability("se:cdp") != null) && this.cdpEnabled) {
            String cdpPath = String.format("/session/%s/se/cdp", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:cdp", (Object)this.rewrite(cdpPath));
        } else {
            MutableCapabilities cdpFiltered = new MutableCapabilities();
            toUse.asMap().forEach((key, value) -> {
                if (!key.startsWith("se:cdp")) {
                    cdpFiltered.setCapability(key, value);
                }
            });
            toUse = new PersistentCapabilities((Capabilities)cdpFiltered).setCapability("se:cdpEnabled", (Object)false);
        }
        Object webSocketUrl = toUse.getCapability("webSocketUrl");
        boolean bl = bidiSupported = isSupportingBiDi && webSocketUrl instanceof String;
        if (bidiSupported && this.bidiEnabled) {
            String biDiUrl = (String)other.getCapabilities().getCapability("webSocketUrl");
            URI uri = null;
            try {
                uri = new URI(biDiUrl);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to create URI from " + String.valueOf(uri));
            }
            String bidiPath = String.format("/session/%s/se/bidi", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:gridWebSocketUrl", (Object)uri).setCapability("webSocketUrl", (Object)this.rewrite(bidiPath));
        } else {
            MutableCapabilities bidiFiltered = new MutableCapabilities();
            toUse.asMap().forEach((key, value) -> {
                if (!key.startsWith("webSocketUrl")) {
                    bidiFiltered.setCapability(key, value);
                }
            });
            toUse = new PersistentCapabilities((Capabilities)bidiFiltered).setCapability("se:bidiEnabled", (Object)false);
        }
        boolean bl2 = isVncEnabled = toUse.getCapability("se:vncLocalAddress") != null;
        if (isVncEnabled) {
            String vncPath = String.format("/session/%s/se/vnc", other.getId());
            toUse = new PersistentCapabilities((Capabilities)toUse).setCapability("se:vnc", (Object)this.rewrite(vncPath));
        }
        return new Session(other.getId(), externalUri, other.getStereotype(), (Capabilities)toUse, Instant.now());
    }

    private URI rewrite(String path) {
        try {
            String scheme = "https".equals(this.gridUri.getScheme()) ? "wss" : "ws";
            path = NodeOptions.normalizeSubPath(this.gridUri.getPath()) + (String)path;
            return new URI(scheme, this.gridUri.getUserInfo(), this.gridUri.getHost(), this.gridUri.getPort(), (String)path, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NodeStatus getStatus() {
        Set slots = (Set)this.factories.stream().map(slot -> {
            ActiveSession activeSession;
            Instant lastStarted = Instant.EPOCH;
            Session session = null;
            if (!slot.isAvailable() && (activeSession = slot.getSession()) != null) {
                lastStarted = activeSession.getStartTime();
                session = new Session(activeSession.getId(), activeSession.getUri(), slot.getStereotype(), activeSession.getCapabilities(), activeSession.getStartTime());
            }
            return new Slot(new SlotId(this.getId(), slot.getId()), slot.getStereotype(), lastStarted, session);
        }).collect(ImmutableSet.toImmutableSet());
        Availability availability = this.isDraining() ? Availability.DRAINING : Availability.UP;
        Optional<SessionSlot> relaySlot = this.factories.stream().filter(SessionSlot::hasRelayFactory).findFirst();
        if (relaySlot.isPresent() && !relaySlot.get().isRelayServiceUp()) {
            availability = Availability.DOWN;
        }
        return new NodeStatus(this.getId(), this.externalUri, this.maxSessionCount, slots, availability, this.heartbeatPeriod, this.getSessionTimeout(), this.getNodeVersion(), (Map<String, String>)this.getOsInfo());
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void drain() {
        this.bus.fire(new NodeDrainStarted(this.getId()));
        this.draining = true;
        int currentSessionCount = this.getCurrentSessionCount();
        if (currentSessionCount == 0) {
            LOG.info("Firing node drain complete message");
            this.bus.fire(new NodeDrainComplete(this.getId()));
        } else {
            this.pendingSessions.set(currentSessionCount);
        }
    }

    private void checkSessionCount() {
        if (this.drainAfterSessions.get()) {
            int remainingSessions = this.sessionCount.decrementAndGet();
            LOG.log(Debug.getDebugLogLevel(), "{0} remaining sessions before draining Node", remainingSessions);
            if (remainingSessions <= 0) {
                LOG.info(String.format("Draining Node, configured sessions value (%s) has been reached.", this.configuredSessionCount));
                this.drain();
            }
        }
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"maxSessions", (Object)this.maxSessionCount, (Object)"draining", (Object)this.isDraining(), (Object)"capabilities", this.factories.stream().map(SessionSlot::getStereotype).collect(Collectors.toSet()));
    }

    public static class Builder {
        private final Tracer tracer;
        private final EventBus bus;
        private final URI uri;
        private final URI gridUri;
        private final Secret registrationSecret;
        private final ImmutableList.Builder<SessionSlot> factories;
        private int maxSessions = NodeOptions.DEFAULT_MAX_SESSIONS;
        private int drainAfterSessionCount = 0;
        private boolean cdpEnabled = true;
        private boolean bidiEnabled = true;
        private Ticker ticker = Ticker.systemTicker();
        private Duration sessionTimeout = Duration.ofSeconds(300L);
        private HealthCheck healthCheck;
        private Duration heartbeatPeriod = Duration.ofSeconds(60L);
        private boolean managedDownloadsEnabled = false;
        private int connectionLimitPerSession = -1;

        private Builder(Tracer tracer, EventBus bus, URI uri, URI gridUri, Secret registrationSecret) {
            this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
            this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
            this.uri = (URI)Require.nonNull((String)"Remote node URI", (Object)uri);
            this.gridUri = (URI)Require.nonNull((String)"Grid URI", (Object)gridUri);
            this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
            this.factories = ImmutableList.builder();
        }

        public Builder add(Capabilities stereotype, SessionFactory factory) {
            Require.nonNull((String)"Capabilities", (Object)stereotype);
            Require.nonNull((String)"Session factory", (Object)factory);
            this.factories.add((Object)new SessionSlot(this.bus, stereotype, factory));
            return this;
        }

        public Builder maximumConcurrentSessions(int maxCount) {
            this.maxSessions = Require.positive((String)"Max session count", (Integer)maxCount);
            return this;
        }

        public Builder drainAfterSessionCount(int sessionCount) {
            this.drainAfterSessionCount = sessionCount;
            return this;
        }

        public Builder enableCdp(boolean cdpEnabled) {
            this.cdpEnabled = cdpEnabled;
            return this;
        }

        public Builder enableBiDi(boolean bidiEnabled) {
            this.bidiEnabled = bidiEnabled;
            return this;
        }

        public Builder sessionTimeout(Duration timeout) {
            this.sessionTimeout = timeout;
            return this;
        }

        public Builder heartbeatPeriod(Duration heartbeatPeriod) {
            this.heartbeatPeriod = heartbeatPeriod;
            return this;
        }

        public Builder enableManagedDownloads(boolean enable) {
            this.managedDownloadsEnabled = enable;
            return this;
        }

        public Builder connectionLimitPerSession(int connectionLimitPerSession) {
            this.connectionLimitPerSession = connectionLimitPerSession;
            return this;
        }

        public LocalNode build() {
            return new LocalNode(this.tracer, this.bus, this.uri, this.gridUri, this.healthCheck, this.maxSessions, this.drainAfterSessionCount, this.cdpEnabled, this.bidiEnabled, this.ticker, this.sessionTimeout, this.heartbeatPeriod, (List<SessionSlot>)this.factories.build(), this.registrationSecret, this.managedDownloadsEnabled, this.connectionLimitPerSession);
        }

        public Advanced advanced() {
            return new Advanced();
        }

        public class Advanced {
            public Advanced clock(final Clock clock) {
                Builder.this.ticker = new Ticker(){

                    public long read() {
                        return clock.instant().toEpochMilli() * Duration.ofMillis(1L).toNanos();
                    }
                };
                return this;
            }

            public Advanced healthCheck(HealthCheck healthCheck) {
                Builder.this.healthCheck = (HealthCheck)Require.nonNull((String)"Health check", (Object)healthCheck);
                return this;
            }

            public Node build() {
                return Builder.this.build();
            }
        }
    }
}

