/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Set;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.ImageId;
import org.openqa.selenium.docker.internal.ImageSummary;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Image {
    private final ImageSummary summary;

    public Image(ImageSummary summary) {
        this.summary = (ImageSummary)Require.nonNull((String)"Container image summary", (Object)summary);
    }

    public String getName() {
        return (String)this.summary.getRepoTags().stream().findFirst().orElseThrow(() -> new DockerException("Unable to find name"));
    }

    public ImageId getId() {
        return this.summary.getId();
    }

    public Set<String> getTags() {
        return this.summary.getRepoTags();
    }

    public String toString() {
        new Json().toJson((Object)this.summary);
        return "Image{summary=" + String.valueOf(this.summary) + "}";
    }
}

