/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;

public class DescribedOption
implements Comparable<DescribedOption> {
    public final String section;
    public final String optionName;
    public final String description;
    public final String type;
    public final String[] example;
    public final String defaultValue;
    public final boolean prefixed;
    public final boolean repeats;
    public final boolean quotable;
    public final boolean hidden;
    public final Set<String> flags;

    DescribedOption(Type type, Parameter parameter, ConfigValue configValue, String defaultValue) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(parameter);
        Objects.requireNonNull(configValue);
        Objects.requireNonNull(defaultValue);
        this.section = configValue.section();
        this.optionName = configValue.name();
        this.type = this.getType(type);
        this.description = parameter.description();
        this.prefixed = configValue.prefixed();
        this.repeats = this.isCollection(type);
        this.quotable = this.isTomlStringType(type);
        this.example = configValue.example();
        this.flags = ImmutableSortedSet.naturalOrder().add((Object[])parameter.names()).build();
        this.defaultValue = defaultValue;
        this.hidden = parameter.hidden();
    }

    public static Set<DescribedOption> findAllMatchingOptions(Collection<Role> roles) {
        Objects.requireNonNull(roles);
        ImmutableSet minimized = ImmutableSet.copyOf(roles);
        return (Set)StreamSupport.stream(ServiceLoader.load(HasRoles.class).spliterator(), false).filter(arg_0 -> DescribedOption.lambda$findAllMatchingOptions$0((Set)minimized, arg_0)).flatMap(DescribedOption::getAllFields).collect(ImmutableSortedSet.toImmutableSortedSet(Comparator.naturalOrder()));
    }

    private static Stream<DescribedOption> getAllFields(HasRoles hasRoles) {
        HashSet<DescribedOption> fields = new HashSet<DescribedOption>();
        for (Class<?> clazz = hasRoles.getClass(); clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                Parameter param = field.getAnnotation(Parameter.class);
                ConfigValue configValue = field.getAnnotation(ConfigValue.class);
                String fieldValue = "";
                try {
                    Object fieldInstance = field.get(clazz.newInstance());
                    fieldValue = fieldInstance == null ? "" : fieldInstance.toString();
                }
                catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                    // empty catch block
                }
                if (param == null || configValue == null) continue;
                fields.add(new DescribedOption(field.getGenericType(), param, configValue, fieldValue));
            }
        }
        return fields.stream();
    }

    public String section() {
        return this.section;
    }

    public String optionName() {
        return this.optionName;
    }

    public String description() {
        return this.description;
    }

    public boolean repeats() {
        return this.repeats;
    }

    public boolean requiresTomlQuoting() {
        return this.quotable;
    }

    public String[] example() {
        return this.example;
    }

    public String example(Config config, String example) {
        Optional<List<String>> allOptions = config.getAll(this.section, this.optionName);
        if (allOptions.isPresent() && !allOptions.get().isEmpty()) {
            if (this.repeats) {
                return allOptions.get().stream().map(value -> this.quotable ? "\"" + value + "\"" : String.valueOf(value)).collect(Collectors.joining(", ", "[", "]"));
            }
            String value2 = allOptions.get().get(0);
            return this.quotable ? "\"" + value2 + "\"" : value2;
        }
        return example;
    }

    public Set<String> flags() {
        return this.flags;
    }

    @Override
    public int compareTo(DescribedOption o) {
        return Comparator.comparing(describedOption -> describedOption.section).thenComparing(describedOption -> describedOption.optionName).compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DescribedOption that = (DescribedOption)o;
        return this.repeats == that.repeats && this.quotable == that.quotable && Objects.equals(this.section, that.section) && Objects.equals(this.optionName, that.optionName) && Objects.equals(this.description, that.description) && Objects.equals(this.defaultValue, that.defaultValue) && Objects.equals(this.type, that.type) && Arrays.equals(this.example, that.example) && Objects.equals(this.flags, that.flags);
    }

    public int hashCode() {
        return Objects.hash(this.section, this.optionName, this.description, this.type, Arrays.hashCode(this.example), this.repeats, this.quotable, this.flags, this.defaultValue);
    }

    public String getType(Type type) {
        String className = this.deriveClass(type).getSimpleName().toLowerCase();
        return this.isCollection(type) ? "list of " + className + "s" : className;
    }

    private boolean isTomlStringType(Type type) {
        Class derived = Primitives.wrap(this.deriveClass(type));
        return !Number.class.isAssignableFrom(derived) && !Boolean.class.isAssignableFrom(derived);
    }

    private Class<?> deriveClass(Type type) {
        Type[] typeArgs;
        if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType()) && (typeArgs = ((ParameterizedType)type).getActualTypeArguments()).length == 1 && typeArgs[0] instanceof Class) {
            return (Class)typeArgs[0];
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        throw new IllegalStateException("Unknown type: " + String.valueOf(type));
    }

    private boolean isCollection(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() instanceof Class && Collection.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
    }

    private static /* synthetic */ boolean lambda$findAllMatchingOptions$0(Set minimized, HasRoles hasRoles) {
        return !Sets.intersection(hasRoles.getRoles(), (Set)minimized).isEmpty();
    }
}

