/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.server;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class EventBusFlags
implements HasRoles {
    @Parameter(names={"--publish-events"}, description="Connection string for publishing events to the event bus")
    @ConfigValue(section="events", name="publish", example={"\"tcp://*:1233\""})
    private String publishString;
    @Parameter(names={"--subscribe-events"}, description="Connection string for subscribing to events from the event bus")
    @ConfigValue(section="events", name="subscribe", example={"\"tcp://*1232\""})
    private String subscribeString;
    @Parameter(names={"--bind-bus"}, description="Whether the connection string should be bound or connected. When true, the component will be bound to the Event Bus (as in the Event Bus will also be started by the component, typically by the Distributor and the Hub). When false, the component will connect to the Event Bus.", arity=1)
    @ConfigValue(section="events", name="bind", example={"false"})
    private Boolean bind;
    @Parameter(names={"--events-implementation"}, description="Full classname of non-default event bus implementation")
    @ConfigValue(section="events", name="implementation", example={"org.openqa.selenium.events.zeromq.ZeroMqEventBus"})
    private String implementation;

    public Set<Role> getRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE);
    }
}

