/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import java.time.Duration;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;

@ManagedService(objectName="org.seleniumhq.grid:type=Config,name=NewSessionQueueConfig", description="New session queue config")
public class SessionRequestOptions {
    static final int DEFAULT_REQUEST_TIMEOUT = 300;
    static final int DEFAULT_RETRY_INTERVAL = 5;
    private final Config config;

    public SessionRequestOptions(Config config) {
        this.config = config;
        new JMXHelper().register(this);
    }

    public Duration getSessionRequestTimeout() {
        int timeout = Math.max(this.config.getInt("sessionqueue", "session-request-timeout").orElse(300), 1);
        return Duration.ofSeconds(timeout);
    }

    public Duration getSessionRequestRetryInterval() {
        int interval = Math.max(this.config.getInt("sessionqueue", "session-retry-interval").orElse(300), 1);
        return Duration.ofSeconds(interval);
    }

    @ManagedAttribute(name="RequestTimeoutSeconds")
    public long getRequestTimeoutSeconds() {
        return this.getSessionRequestTimeout().getSeconds();
    }

    @ManagedAttribute(name="RetryIntervalSeconds")
    public long getRetryIntervalSeconds() {
        return this.getSessionRequestRetryInterval().getSeconds();
    }
}

