/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.config;

import com.beust.jcommander.Parameter;
import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Set;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;

@AutoService(value={HasRoles.class})
public class SessionRequestFlags
implements HasRoles {
    @Parameter(names={"--session-request-timeout"}, description="Timeout in seconds. New incoming session request is added to the queue. Requests sitting in the queue for longer than the configured time will timeout.")
    @ConfigValue(section="sessionqueue", name="session-request-timeout", example={"5"})
    private int sessionRequestTimeout = 300;
    @Parameter(names={"--session-retry-interval"}, description="Retry interval in seconds. If all slots are busy, new session request will be retried after the given interval.")
    @ConfigValue(section="sessionqueue", name="session-retry-interval", example={"5"})
    private int sessionRetryInterval = 5;

    public Set<Role> getRoles() {
        return Collections.singleton(StandardGridRoles.SESSION_QUEUE_ROLE);
    }
}

