/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.router.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.remote.RemoteDistributor;
import org.openqa.selenium.grid.graphql.GraphqlHandler;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.router.ProxyWebsocketsIntoGrid;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.security.BasicAuthenticationFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.remote.RemoteNewSessionQueue;
import org.openqa.selenium.grid.web.GridUiRoute;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

@AutoService(value={CliCommand.class})
public class RouterServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(RouterServer.class.getName());

    @Override
    public String getName() {
        return "router";
    }

    @Override
    public String getDescription() {
        return "Creates a router to front the selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.DISTRIBUTOR_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.ROUTER_ROLE, (Object)StandardGridRoles.SESSION_MAP_ROLE, (Object)StandardGridRoles.SESSION_QUEUE_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "router";
    }

    @Override
    protected Config getDefaultConfig() {
        return new MapConfig((Map)ImmutableMap.of((Object)"server", (Object)ImmutableMap.of((Object)"port", (Object)4444)));
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret secret = secretOptions.getRegistrationSecret();
        SessionMapOptions sessionsOptions = new SessionMapOptions(config);
        SessionMap sessions = sessionsOptions.getSessionMap();
        NewSessionQueueOptions sessionQueueOptions = new NewSessionQueueOptions(config);
        URL sessionQueueUrl = Urls.fromUri((URI)sessionQueueOptions.getSessionQueueUri());
        RemoteNewSessionQueue queue = new RemoteNewSessionQueue(tracer, clientFactory.createClient(sessionQueueUrl), secret);
        DistributorOptions distributorOptions = new DistributorOptions(config);
        URL distributorUrl = Urls.fromUri((URI)distributorOptions.getDistributorUri());
        RemoteDistributor distributor = new RemoteDistributor(tracer, clientFactory, distributorUrl, secret);
        GraphqlHandler graphqlHandler = new GraphqlHandler(tracer, distributor, queue, serverOptions.getExternalUri(), this.getServerVersion());
        GridUiRoute ui = new GridUiRoute();
        Routable routerWithSpecChecks = new Router(tracer, clientFactory, sessions, queue, distributor).with(networkOptions.getSpecComplianceChecks());
        Route route = Route.combine((Routable)ui, (Routable[])new Routable[]{routerWithSpecChecks, Route.prefix((String)"/wd/hub").to(Route.combine((Routable)routerWithSpecChecks, (Routable[])new Routable[0])), Route.options((String)"/graphql").to(() -> graphqlHandler), Route.post((String)"/graphql").to(() -> graphqlHandler)});
        UsernameAndPassword uap = secretOptions.getServerAuthentication();
        if (uap != null) {
            LOG.info("Requiring authentication to connect");
            route = route.with((Filter)new BasicAuthenticationFilter(uap.username(), uap.password()));
        }
        Route routeWithLiveness = Route.combine((Routable)route, (Routable[])new Routable[]{Route.get((String)"/readyz").to(() -> req -> new HttpResponse().setStatus(204))});
        return new TemplateGridServerCommand.Handlers((HttpHandler)routeWithLiveness, new ProxyWebsocketsIntoGrid(clientFactory, sessions));
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server server = (Server)this.asServer(config).start();
        LOG.info(String.format("Started Selenium Router %s: %s", this.getServerVersion(), server.getUrl()));
    }

    private String getServerVersion() {
        BuildInfo info = new BuildInfo();
        return String.format("%s (revision %s)", info.getReleaseLabel(), info.getBuildRevision());
    }
}

