/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

public abstract class NewSessionQueue
implements HasReadyState {
    protected final Tracer tracer;
    protected final Duration retryInterval;
    protected final Duration requestTimeout;

    protected NewSessionQueue(Tracer tracer, Duration retryInterval, Duration requestTimeout) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.retryInterval = (Duration)Require.nonNull((String)"Session request retry interval", (Object)retryInterval);
        this.requestTimeout = (Duration)Require.nonNull((String)"Session request timeout", (Object)requestTimeout);
    }

    public abstract boolean offerLast(SessionRequest var1);

    public abstract boolean offerFirst(SessionRequest var1);

    public abstract Optional<SessionRequest> remove(RequestId var1);

    public abstract int clear();

    public abstract int getQueueSize();

    public abstract List<Set<Capabilities>> getQueuedRequests();

    public boolean hasRequestTimedOut(SessionRequest request) {
        Instant deque;
        Instant enque = request.getEnqueued();
        Duration duration = Duration.between(enque, deque = Instant.now());
        return duration.compareTo(this.requestTimeout) > 0;
    }
}

