/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker.v1_40;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.openqa.selenium.docker.ContainerId;
import org.openqa.selenium.docker.ContainerLogs;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

class GetContainerLogs {
    private static final Logger LOG = Logger.getLogger(GetContainerLogs.class.getName());
    private final HttpHandler client;

    public GetContainerLogs(HttpHandler client) {
        this.client = (HttpHandler)Require.nonNull((String)"HTTP client", (Object)client);
    }

    public ContainerLogs apply(ContainerId id) {
        Require.nonNull((String)"Container id", (Object)id);
        String requestUrl = String.format("/v1.40/containers/%s/logs?stdout=true&stderr=true", id);
        HttpResponse res = this.client.execute((HttpRequest)((HttpRequest)new HttpRequest(HttpMethod.GET, requestUrl).addHeader("Content-Length", "0")).addHeader("Content-Type", "text/plain"));
        if (res.getStatus() != 200) {
            LOG.warning("Unable to inspect container " + id);
        }
        List<String> logLines = Arrays.asList(Contents.string((HttpMessage)res).split("\n"));
        return new ContainerLogs(id, logLines);
    }
}

