/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.local;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalSessionMap
extends SessionMap {
    private static final Logger LOG = Logger.getLogger(LocalSessionMap.class.getName());
    private final EventBus bus;
    private final Map<SessionId, Session> knownSessions = new ConcurrentHashMap<SessionId, Session>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public LocalSessionMap(Tracer tracer, EventBus bus) {
        super(tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        bus.addListener(SessionClosedEvent.listener(id -> {
            try (Span span = tracer.getCurrentContext().createSpan("local_sessionmap.remove");){
                HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
                attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
                RemoteTags.SESSION_ID.accept(span, id);
                RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
                this.knownSessions.remove(id);
                String sessionDeletedMessage = "Deleted session from local session map";
                span.addEvent(sessionDeletedMessage, attributeMap);
                LOG.info(String.format("%s, Id: %s", sessionDeletedMessage, id));
            }
        }));
    }

    public static SessionMap create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        return new LocalSessionMap(tracer, bus);
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    @Override
    public boolean add(Session session) {
        Require.nonNull((String)"Session", (Object)session);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            boolean bl;
            block9: {
                Span span = this.tracer.getCurrentContext().createSpan("local_sessionmap.add");
                try {
                    HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
                    attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), EventAttribute.setValue((String)this.getClass().getName()));
                    SessionId id = session.getId();
                    RemoteTags.SESSION_ID.accept(span, id);
                    RemoteTags.SESSION_ID_EVENT.accept(attributeMap, id);
                    this.knownSessions.put(session.getId(), session);
                    span.addEvent("Added session into local session map", attributeMap);
                    bl = true;
                    if (span == null) break block9;
                }
                catch (Throwable throwable) {
                    if (span != null) {
                        try {
                            span.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                span.close();
            }
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session get(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Session session = this.knownSessions.get(id);
            if (session == null) {
                throw new NoSuchSessionException("Unable to find session with ID: " + id);
            }
            Session session2 = session;
            return session2;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void remove(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.knownSessions.remove(id);
        }
        finally {
            writeLock.unlock();
        }
    }
}

