/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.httpd;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.grid.TemplateGridServerCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.httpd.DefaultDistributorConfig;
import org.openqa.selenium.grid.server.Server;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;

@AutoService(value={CliCommand.class})
public class DistributorServer
extends TemplateGridServerCommand {
    private static final Logger LOG = Logger.getLogger(DistributorServer.class.getName());

    @Override
    public String getName() {
        return "distributor";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the distributor in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.DISTRIBUTOR_ROLE, (Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.SESSION_MAP_ROLE, (Object)StandardGridRoles.SESSION_QUEUER_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "distributor";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultDistributorConfig();
    }

    @Override
    protected TemplateGridServerCommand.Handlers createHandlers(Config config) {
        DistributorOptions distributorOptions = new DistributorOptions(config);
        Distributor distributor = distributorOptions.getDistributor();
        HttpHandler readinessCheck = req -> {
            boolean ready = distributor.isReady();
            return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(ready ? 200 : 500).setHeader("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString())).setContent(Contents.utf8String((CharSequence)("Distributor is " + ready)));
        };
        return new TemplateGridServerCommand.Handlers((HttpHandler)Route.combine((Routable)distributor, (Routable[])new Routable[]{Route.matching(req -> HttpMethod.GET.equals((Object)req.getMethod()) && "/status".equals(req.getUri())).to(() -> req -> (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)true, (Object)"message", (Object)"Distributor is ready"))))), Route.get((String)"/readyz").to(() -> readinessCheck)}), null);
    }

    @Override
    protected void execute(Config config) {
        Require.nonNull((String)"Config", (Object)config);
        Server server = (Server)this.asServer(config).start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium distributor %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

