/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.net.MediaType;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.web.Resource;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.UrlPath;

public class ResourceHandler
implements Routable {
    private final Resource resource;

    public ResourceHandler(Resource resource) {
        this.resource = (Resource)Require.nonNull((String)"Resource", (Object)resource);
    }

    public boolean matches(HttpRequest req) {
        return HttpMethod.GET == req.getMethod() && this.resource.get(req.getUri()).isPresent();
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        Optional<Resource> result = this.resource.get(req.getUri());
        if (!result.isPresent()) {
            return (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.utf8String((CharSequence)("Unable to find " + req.getUri())));
        }
        Resource resource = result.get();
        if (resource.isDirectory()) {
            Optional<Resource> index = resource.get("index.html");
            if (index.isPresent()) {
                return this.readFile(req, index.get());
            }
            return this.readDirectory(req, resource);
        }
        return this.readFile(req, resource);
    }

    private HttpResponse readDirectory(HttpRequest req, Resource resource) {
        if (!req.getUri().endsWith("/")) {
            String dest = UrlPath.relativeToContext((HttpRequest)req, (String)(req.getUri() + "/"));
            return (HttpResponse)new HttpResponse().setStatus(302).addHeader("Location", dest);
        }
        String links = resource.list().stream().map(res -> String.format("<li><a href=\"%s\">%s</a>", res.name(), res.name())).sorted().collect(Collectors.joining("\n", "<ul>\n", "</ul>\n"));
        String html = String.format("<html><title>Listing of %s</title><body><h1>%s</h1>%s", resource.name(), resource.name(), links);
        return (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", MediaType.HTML_UTF_8.toString())).setContent(Contents.utf8String((CharSequence)html));
    }

    private HttpResponse readFile(HttpRequest req, Resource resource) {
        Optional<byte[]> bytes = resource.read();
        if (bytes.isPresent()) {
            return (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", this.mediaType(req.getUri()))).setContent(Contents.bytes((byte[])bytes.get()));
        }
        return this.get404(req);
    }

    private HttpResponse get404(HttpRequest req) {
        return (HttpResponse)new HttpResponse().setStatus(404).setContent(Contents.utf8String((CharSequence)("Unable to read " + req.getUri())));
    }

    private String mediaType(String uri) {
        MediaType type;
        int index = uri.lastIndexOf(".");
        String extension = index == -1 || uri.length() == index ? "" : uri.substring(index + 1);
        switch (extension.toLowerCase()) {
            case "appcache": {
                type = MediaType.CACHE_MANIFEST_UTF_8;
                break;
            }
            case "dll": 
            case "ttf": {
                type = MediaType.OCTET_STREAM;
                break;
            }
            case "css": {
                type = MediaType.CSS_UTF_8;
                break;
            }
            case "gif": {
                type = MediaType.GIF;
                break;
            }
            case "jpeg": 
            case "jpg": {
                type = MediaType.JPEG;
                break;
            }
            case "js": {
                type = MediaType.JAVASCRIPT_UTF_8;
                break;
            }
            case "md": 
            case "txt": {
                type = MediaType.PLAIN_TEXT_UTF_8;
                break;
            }
            case "png": {
                type = MediaType.PNG;
                break;
            }
            case "svg": {
                type = MediaType.SVG_UTF_8;
                break;
            }
            case "woff": {
                type = MediaType.WOFF;
                break;
            }
            case "xhtml": {
                type = MediaType.XHTML_UTF_8;
                break;
            }
            case "xml": {
                type = MediaType.XML_UTF_8;
                break;
            }
            case "xsl": {
                type = MediaType.create((String)"application", (String)"xslt+xml").withCharset(StandardCharsets.UTF_8);
                break;
            }
            default: {
                type = MediaType.HTML_UTF_8;
            }
        }
        return type.toString();
    }
}

