/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.graphql.Session;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;

public class Node {
    private final NodeId id;
    private final URI uri;
    private final Availability status;
    private final int maxSession;
    private final Map<Capabilities, Integer> capabilities;
    private static final Json JSON = new Json();
    private final Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions;

    public Node(NodeId id, URI uri, Availability status, int maxSession, Map<Capabilities, Integer> capabilities, Map<org.openqa.selenium.grid.data.Session, Slot> activeSessions) {
        this.id = (NodeId)Require.nonNull((String)"Node id", (Object)id);
        this.uri = (URI)Require.nonNull((String)"Node uri", (Object)uri);
        this.status = status;
        this.maxSession = maxSession;
        this.capabilities = (Map)Require.nonNull((String)"Node capabilities", capabilities);
        this.activeSessions = (Map)Require.nonNull((String)"Active sessions", activeSessions);
    }

    public List<Session> getSessions() {
        return (List)this.activeSessions.entrySet().stream().map(this::createGraphqlSession).collect(ImmutableList.toImmutableList());
    }

    public NodeId getId() {
        return this.id;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public List<String> getActiveSessionIds() {
        return (List)this.activeSessions.keySet().stream().map(session -> session.getId().toString()).collect(ImmutableList.toImmutableList());
    }

    public String getCapabilities() {
        ArrayList toReturn = new ArrayList();
        for (Map.Entry<Capabilities, Integer> entry : this.capabilities.entrySet()) {
            HashMap<String, Object> details = new HashMap<String, Object>();
            details.put("browserName", entry.getKey().getBrowserName());
            details.put("slots", entry.getValue());
            toReturn.add(details);
        }
        return JSON.toJson(toReturn);
    }

    public Availability getStatus() {
        return this.status;
    }

    private Session createGraphqlSession(Map.Entry<org.openqa.selenium.grid.data.Session, Slot> entry) {
        org.openqa.selenium.grid.data.Session session = entry.getKey();
        Slot slot = entry.getValue();
        return new Session(session.getId().toString(), session.getCapabilities(), session.getStartTime(), session.getUri(), this.id.toString(), this.uri, slot);
    }
}

