/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.collect.ImmutableSet;
import java.time.Instant;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.NodeDrainComplete;
import org.openqa.selenium.grid.data.NodeDrainStarted;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeRemovedEvent;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.NodeStatusEvent;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;

public class GridModel {
    private static final Logger LOG = Logger.getLogger(GridModel.class.getName());
    private static final SessionId RESERVED = new SessionId("reserved");
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final Map<Availability, Set<NodeStatus>> nodes = new ConcurrentHashMap<Availability, Set<NodeStatus>>();
    private final EventBus events;

    public GridModel(EventBus events) {
        this.events = (EventBus)Require.nonNull((String)"Event bus", (Object)events);
        this.events.addListener(NodeDrainStarted.listener(nodeId -> this.setAvailability((NodeId)nodeId, Availability.DRAINING)));
        this.events.addListener(NodeDrainComplete.listener(this::remove));
        this.events.addListener(NodeRemovedEvent.listener(this::remove));
        this.events.addListener(NodeStatusEvent.listener(this::refresh));
        this.events.addListener(SessionClosedEvent.listener(this::release));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridModel add(NodeStatus node) {
        Require.nonNull((String)"Node", (Object)node);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            for (Set<NodeStatus> nodes : this.nodes.values()) {
                Iterator<NodeStatus> iterator = nodes.iterator();
                while (iterator.hasNext()) {
                    NodeStatus next = iterator.next();
                    if (!next.getId().equals(node.getId()) && !next.getUri().equals(node.getUri())) continue;
                    LOG.info(String.format("Re-adding node with id %s and URI %s.", node.getId(), node.getUri()));
                    iterator.remove();
                }
            }
            this.nodes(Availability.DOWN).add(node);
        }
        finally {
            writeLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridModel refresh(NodeStatus status) {
        Require.nonNull((String)"Node status", (Object)status);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            AvailabilityAndNode availabilityAndNode = this.findNode(status.getId());
            if (availabilityAndNode == null) {
                GridModel gridModel = this;
                return gridModel;
            }
            if (Availability.DOWN.equals((Object)availabilityAndNode.availability)) {
                this.nodes(Availability.DOWN).remove(availabilityAndNode.status);
                this.nodes(Availability.DOWN).add(status);
                GridModel gridModel = this;
                return gridModel;
            }
            this.nodes(availabilityAndNode.availability).remove(availabilityAndNode.status);
            this.nodes(status.getAvailability()).add(status);
            GridModel gridModel = this;
            return gridModel;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridModel remove(NodeId id) {
        Require.nonNull((String)"Node ID", (Object)id);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            AvailabilityAndNode availabilityAndNode = this.findNode(id);
            if (availabilityAndNode == null) {
                GridModel gridModel = this;
                return gridModel;
            }
            this.nodes(availabilityAndNode.availability).remove(availabilityAndNode.status);
            GridModel gridModel = this;
            return gridModel;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Availability setAvailability(NodeId id, Availability availability) {
        Require.nonNull((String)"Node ID", (Object)id);
        Require.nonNull((String)"Availability", (Object)((Object)availability));
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            AvailabilityAndNode availabilityAndNode = this.findNode(id);
            if (availabilityAndNode == null) {
                Availability availability2 = Availability.DOWN;
                return availability2;
            }
            if (availability.equals((Object)availabilityAndNode.availability)) {
                Availability availability3 = availability;
                return availability3;
            }
            this.nodes(availabilityAndNode.availability).remove(availabilityAndNode.status);
            this.nodes(availability).add(availabilityAndNode.status);
            LOG.info(String.format("Switching node %s (uri: %s) from %s to %s", new Object[]{id, availabilityAndNode.status.getUri(), availabilityAndNode.availability, availability}));
            Availability availability4 = availabilityAndNode.availability;
            return availability4;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reserve(SlotId slotId) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            AvailabilityAndNode node = this.findNode(slotId.getOwningNodeId());
            if (node == null) {
                LOG.warning(String.format("Asked to reserve slot on node %s, but unable to find node", slotId.getOwningNodeId()));
                boolean bl = false;
                return bl;
            }
            if (!Availability.UP.equals((Object)node.availability)) {
                LOG.warning(String.format("Asked to reserve a slot on node %s, but node is %s", new Object[]{slotId.getOwningNodeId(), node.availability}));
                boolean bl = false;
                return bl;
            }
            Optional<Slot> maybeSlot = node.status.getSlots().stream().filter(slot -> slotId.equals(slot.getId())).findFirst();
            if (!maybeSlot.isPresent()) {
                LOG.warning(String.format("Asked to reserve slot on node %s, but no slot with id %s found", node.status.getId(), slotId));
                boolean bl = false;
                return bl;
            }
            this.reserve(node.status, maybeSlot.get());
            boolean bl = true;
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<NodeStatus> getSnapshot() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            ImmutableSet.Builder snapshot = ImmutableSet.builder();
            for (Map.Entry<Availability, Set<NodeStatus>> entry : this.nodes.entrySet()) {
                entry.getValue().stream().map(status -> this.rewrite((NodeStatus)status, (Availability)((Object)((Object)entry.getKey())))).forEach(arg_0 -> ((ImmutableSet.Builder)snapshot).add(arg_0));
            }
            ImmutableSet immutableSet = snapshot.build();
            return immutableSet;
        }
        finally {
            readLock.unlock();
        }
    }

    private Set<NodeStatus> nodes(Availability availability) {
        return this.nodes.computeIfAbsent(availability, ignored -> new HashSet());
    }

    private AvailabilityAndNode findNode(NodeId id) {
        for (Map.Entry<Availability, Set<NodeStatus>> entry : this.nodes.entrySet()) {
            for (NodeStatus nodeStatus : entry.getValue()) {
                if (!id.equals(nodeStatus.getId())) continue;
                return new AvailabilityAndNode(entry.getKey(), nodeStatus);
            }
        }
        return null;
    }

    private NodeStatus rewrite(NodeStatus status, Availability availability) {
        return new NodeStatus(status.getId(), status.getUri(), status.getMaxSessionCount(), status.getSlots(), availability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(SessionId id) {
        if (id == null) {
            return;
        }
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            for (Map.Entry<Availability, Set<NodeStatus>> entry : this.nodes.entrySet()) {
                for (NodeStatus node : entry.getValue()) {
                    for (Slot slot : node.getSlots()) {
                        if (!slot.getSession().isPresent()) continue;
                        if (!id.equals((Object)slot.getSession().get().getId())) continue;
                        Slot released = new Slot(slot.getId(), slot.getStereotype(), slot.getLastStarted(), Optional.empty());
                        this.amend(entry.getKey(), node, released);
                        return;
                    }
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private void reserve(NodeStatus status, Slot slot) {
        Instant now = Instant.now();
        Slot reserved = new Slot(slot.getId(), slot.getStereotype(), now, Optional.of(new Session(RESERVED, status.getUri(), slot.getStereotype(), slot.getStereotype(), now)));
        this.amend(Availability.UP, status, reserved);
    }

    public void setSession(SlotId slotId, Session session) {
        Require.nonNull((String)"Slot ID", (Object)slotId);
        AvailabilityAndNode node = this.findNode(slotId.getOwningNodeId());
        if (node == null) {
            LOG.warning("Grid model and reality have diverged. Unable to find node " + slotId.getOwningNodeId());
            return;
        }
        Optional<Slot> maybeSlot = node.status.getSlots().stream().filter(slot -> slotId.equals(slot.getId())).findFirst();
        if (!maybeSlot.isPresent()) {
            LOG.warning("Grid model and reality have diverged. Unable to find slot " + slotId);
            return;
        }
        Slot slot2 = maybeSlot.get();
        Optional<Session> maybeSession = slot2.getSession();
        if (!maybeSession.isPresent()) {
            LOG.warning("Grid model and reality have diverged. Slot is not reserved. " + slotId);
            return;
        }
        Session current = maybeSession.get();
        if (!RESERVED.equals((Object)current.getId())) {
            LOG.warning("Gid model and reality have diverged. Slot has session and is not reserved. " + slotId);
            return;
        }
        Slot updated = new Slot(slot2.getId(), slot2.getStereotype(), session == null ? slot2.getLastStarted() : session.getStartTime(), Optional.ofNullable(session));
        this.amend(node.availability, node.status, updated);
    }

    private void amend(Availability availability, NodeStatus status, Slot slot) {
        HashSet<Slot> newSlots = new HashSet<Slot>(status.getSlots());
        newSlots.removeIf(s -> s.getId().equals(slot.getId()));
        newSlots.add(slot);
        this.nodes(availability).remove(status);
        this.nodes(availability).add(new NodeStatus(status.getId(), status.getUri(), status.getMaxSessionCount(), newSlots, status.getAvailability()));
    }

    private static class AvailabilityAndNode {
        public final Availability availability;
        public final NodeStatus status;

        public AvailabilityAndNode(Availability availability, NodeStatus status) {
            this.availability = availability;
            this.status = status;
        }
    }
}

