/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.config;

import com.google.common.collect.HashMultimap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.ConfigException;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.config.DriverServiceSessionFactory;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.service.DriverService;
import org.openqa.selenium.remote.tracing.Tracer;

public class NodeOptions {
    private static final Logger LOG = Logger.getLogger(NodeOptions.class.getName());
    private static final Json JSON = new Json();
    private final Config config;

    public NodeOptions(Config config) {
        this.config = (Config)Require.nonNull((String)"Config", (Object)config);
    }

    public Optional<URI> getPublicGridUri() {
        return this.config.get("node", "grid-url").map(url -> {
            try {
                return new URI((String)url);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Unable to construct public URL: " + url, new Object[0]);
            }
        });
    }

    public void configure(Tracer tracer, HttpClient.Factory httpClientFactory, LocalNode.Builder node) {
        int maxSessions = Math.min(this.config.getInt("node", "max-concurrent-sessions").orElse(Runtime.getRuntime().availableProcessors()), Runtime.getRuntime().availableProcessors());
        Map<WebDriverInfo, Collection<SessionFactory>> allDrivers = this.discoverDrivers(tracer, httpClientFactory, maxSessions);
        List drivers = ((List)this.config.getAll("node", "drivers").orElse(new ArrayList())).stream().map(String::toLowerCase).collect(Collectors.toList());
        if (!drivers.isEmpty()) {
            allDrivers.entrySet().stream().filter(entry -> drivers.contains(((WebDriverInfo)entry.getKey()).getDisplayName().toLowerCase())).peek(this::report).forEach(entry -> ((Collection)entry.getValue()).forEach(factory -> node.add(((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (SessionFactory)factory)));
            return;
        }
        if (!this.config.getBool("node", "detect-drivers").orElse(false).booleanValue()) {
            return;
        }
        allDrivers.entrySet().stream().peek(this::report).forEach(entry -> ((Collection)entry.getValue()).forEach(factory -> node.add(((WebDriverInfo)entry.getKey()).getCanonicalCapabilities(), (SessionFactory)factory)));
    }

    private void report(Map.Entry<WebDriverInfo, Collection<SessionFactory>> entry) {
        StringBuilder caps = new StringBuilder();
        try (JsonOutput out = JSON.newOutput((Appendable)caps);){
            out.setPrettyPrint(false);
            out.write((Object)entry.getKey().getCanonicalCapabilities());
        }
        LOG.info(String.format("Adding %s for %s %d times", entry.getKey().getDisplayName(), caps.toString().replaceAll("\\s+", " "), entry.getValue().size()));
    }

    private Map<WebDriverInfo, Collection<SessionFactory>> discoverDrivers(Tracer tracer, HttpClient.Factory clientFactory, int maxSessions) {
        List<WebDriverInfo> infos = StreamSupport.stream(ServiceLoader.load(WebDriverInfo.class).spliterator(), false).filter(WebDriverInfo::isAvailable).collect(Collectors.toList());
        ArrayList builders = new ArrayList();
        ServiceLoader.load(DriverService.Builder.class).forEach(builders::add);
        HashMultimap toReturn = HashMultimap.create();
        infos.forEach(info -> {
            Capabilities caps = info.getCanonicalCapabilities();
            builders.stream().filter(builder -> builder.score(caps) > 0).forEach(builder -> {
                for (int i = 0; i < Math.min(info.getMaximumSimultaneousSessions(), maxSessions); ++i) {
                    DriverService.Builder freePortBuilder = builder.usingAnyFreePort();
                    toReturn.put(info, (Object)new DriverServiceSessionFactory(tracer, clientFactory, c -> freePortBuilder.score(c) > 0, freePortBuilder));
                }
            });
        });
        return toReturn.asMap();
    }
}

