/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.chromium.ChromiumDevToolsLocator;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.BinaryMessage;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.CloseMessage;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.Message;
import org.openqa.selenium.remote.http.TextMessage;
import org.openqa.selenium.remote.http.UrlTemplate;
import org.openqa.selenium.remote.http.WebSocket;

public class ProxyNodeCdp
implements BiFunction<String, Consumer<Message>, Optional<Consumer<Message>>> {
    private static final UrlTemplate CDP_TEMPLATE = new UrlTemplate("/session/{sessionId}/se/cdp");
    private static final Logger LOG = Logger.getLogger(ProxyNodeCdp.class.getName());
    private final HttpClient.Factory clientFactory;
    private final Node node;

    public ProxyNodeCdp(HttpClient.Factory clientFactory, Node node) {
        this.clientFactory = Objects.requireNonNull(clientFactory);
        this.node = Objects.requireNonNull(node);
    }

    @Override
    public Optional<Consumer<Message>> apply(String uri, Consumer<Message> downstream) {
        UrlTemplate.Match match = CDP_TEMPLATE.match(uri);
        if (match == null) {
            return Optional.empty();
        }
        LOG.fine("Matching CDP session for " + (String)match.getParameters().get("sessionId"));
        SessionId id = new SessionId((String)match.getParameters().get("sessionId"));
        if (!this.node.isSessionOwner(id)) {
            LOG.info("Not owner of " + id);
            return Optional.empty();
        }
        Session session = this.node.getSession(id);
        Capabilities caps = session.getCapabilities();
        LOG.fine("Scanning for CDP endpoint: " + caps);
        Optional<Consumer> cdpUri = ChromiumDevToolsLocator.getReportedUri((String)"goog:chromeOptions", (Capabilities)caps).flatMap(reported -> ChromiumDevToolsLocator.getCdpEndPoint((HttpClient.Factory)this.clientFactory, (URI)reported));
        if (cdpUri.isPresent()) {
            LOG.fine("Chrome endpoint found");
            return cdpUri.map(cdp -> this.createCdpEndPoint((URI)cdp, downstream));
        }
        LOG.fine("Searching for edge options");
        cdpUri = ChromiumDevToolsLocator.getReportedUri((String)"ms:edgeOptions", (Capabilities)caps).flatMap(reported -> ChromiumDevToolsLocator.getCdpEndPoint((HttpClient.Factory)this.clientFactory, (URI)reported));
        return cdpUri.map(cdp -> this.createCdpEndPoint((URI)cdp, downstream));
    }

    private Consumer<Message> createCdpEndPoint(URI uri, Consumer<Message> downstream) {
        Objects.requireNonNull(uri);
        LOG.info("Establishing CDP connection to " + uri);
        HttpClient client = this.clientFactory.createClient(ClientConfig.defaultConfig().baseUri(uri));
        WebSocket upstream = client.openSocket(new HttpRequest(HttpMethod.GET, uri.toString()), (WebSocket.Listener)new ForwardingListener(downstream));
        return arg_0 -> ((WebSocket)upstream).send(arg_0);
    }

    private static class ForwardingListener
    implements WebSocket.Listener {
        private final Consumer<Message> downstream;

        public ForwardingListener(Consumer<Message> downstream) {
            this.downstream = Objects.requireNonNull(downstream);
        }

        public void onBinary(byte[] data) {
            this.downstream.accept((Message)new BinaryMessage(data));
        }

        public void onClose(int code, String reason) {
            this.downstream.accept((Message)new CloseMessage(code, reason));
        }

        public void onText(CharSequence data) {
            this.downstream.accept((Message)new TextMessage(data));
        }

        public void onError(Throwable cause) {
            LOG.log(Level.WARNING, "Error proxying CDP command", cause);
        }
    }
}

