/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.graphql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.preparsed.PreparsedDocumentEntry;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaGenerator;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.graphql.GridData;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class GraphqlHandler
implements HttpHandler {
    public static final String GRID_SCHEMA = "/org/openqa/selenium/graphql/selenium-grid-schema.graphqls";
    public static final Json JSON = new Json();
    private final Distributor distributor;
    private final String publicUrl;
    private final GraphQL graphQl;

    public GraphqlHandler(Distributor distributor, String publicUrl) {
        this.distributor = Objects.requireNonNull(distributor);
        this.publicUrl = Objects.requireNonNull(publicUrl);
        GraphQLSchema schema = new SchemaGenerator().makeExecutableSchema(this.buildTypeDefinitionRegistry(), this.buildRuntimeWiring());
        Cache cache = CacheBuilder.newBuilder().maximumSize(1024L).build();
        this.graphQl = GraphQL.newGraphQL((GraphQLSchema)schema).preparsedDocumentProvider((executionInput, computeFunction) -> {
            try {
                return (PreparsedDocumentEntry)cache.get((Object)executionInput.getQuery(), () -> (PreparsedDocumentEntry)computeFunction.apply(executionInput));
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                if (e.getCause() != null) {
                    throw new RuntimeException(e.getCause());
                }
                throw new RuntimeException(e);
            }
        }).build();
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput((String)Contents.string((HttpMessage)req)).build();
        ExecutionResult result = this.graphQl.execute(executionInput);
        if (result.isDataPresent()) {
            return (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)result.toSpecification())));
        }
        return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)result.getErrors())));
    }

    private RuntimeWiring buildRuntimeWiring() {
        return RuntimeWiring.newRuntimeWiring().type("GridQuery", typeWiring -> typeWiring.dataFetcher("grid", (DataFetcher)new GridData(this.publicUrl))).build();
    }

    private TypeDefinitionRegistry buildTypeDefinitionRegistry() {
        TypeDefinitionRegistry typeDefinitionRegistry;
        block8: {
            InputStream stream = this.getClass().getResourceAsStream(GRID_SCHEMA);
            try {
                typeDefinitionRegistry = new SchemaParser().parse(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return typeDefinitionRegistry;
    }
}

