/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import java.util.Objects;
import java.util.function.Supplier;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.SessionId;

public class Slot {
    private final Node node;
    private final Capabilities registeredCapabilities;
    private Status currentStatus;
    private long lastStartedNanos;
    private Session currentSession;

    public Slot(Node node, Capabilities capabilities, Status status) {
        this.node = (Node)Require.nonNull((String)"Node", (Object)node);
        this.registeredCapabilities = (Capabilities)Require.nonNull((String)"Capabilities", (Object)capabilities);
        this.currentStatus = (Status)((Object)Require.nonNull((String)"Status", (Object)((Object)status)));
    }

    public Capabilities getStereotype() {
        return this.registeredCapabilities;
    }

    public Status getStatus() {
        return this.currentStatus;
    }

    public long getLastSessionCreated() {
        return this.lastStartedNanos;
    }

    public boolean isSupporting(Capabilities caps) {
        return this.registeredCapabilities.getCapabilityNames().stream().map(name -> Objects.equals(this.registeredCapabilities.getCapability(name), caps.getCapability(name))).reduce(Boolean::logicalAnd).orElse(false);
    }

    public Supplier<CreateSessionResponse> onReserve(CreateSessionRequest sessionRequest) {
        if (this.getStatus() != Status.AVAILABLE) {
            throw new IllegalStateException("Node is not available");
        }
        this.currentStatus = Status.RESERVED;
        return () -> {
            try {
                CreateSessionResponse sessionResponse = this.node.newSession(sessionRequest).orElseThrow(() -> new SessionNotCreatedException("Unable to create session for " + sessionRequest));
                this.onStart(sessionResponse.getSession());
                return sessionResponse;
            }
            catch (Throwable t) {
                this.currentStatus = Status.AVAILABLE;
                this.currentSession = null;
                throw t;
            }
        };
    }

    public void onStart(Session session) {
        if (this.getStatus() != Status.RESERVED) {
            throw new IllegalStateException("Slot is not reserved");
        }
        this.lastStartedNanos = System.nanoTime();
        this.currentStatus = Status.ACTIVE;
        this.currentSession = (Session)Require.nonNull((String)"Session", (Object)session);
    }

    public void onEnd(SessionId id) {
        if (this.currentSession == null || !this.currentSession.getId().equals((Object)id)) {
            return;
        }
        this.currentStatus = Status.AVAILABLE;
        this.currentSession = null;
    }

    public static enum Status {
        AVAILABLE,
        RESERVED,
        ACTIVE;

    }
}

