/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.httpd;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.TemplateGridCommand;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.grid.distributor.httpd.DefaultDistributorConfig;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.netty.server.NettyServer;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Routable;
import org.openqa.selenium.remote.http.Route;
import org.openqa.selenium.remote.tracing.Tracer;

public class DistributorServer
extends TemplateGridCommand {
    private static final Logger LOG = Logger.getLogger(DistributorServer.class.getName());

    @Override
    public String getName() {
        return "distributor";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the distributor in a selenium grid.";
    }

    @Override
    public Set<Role> getConfigurableRoles() {
        return ImmutableSet.of((Object)StandardGridRoles.EVENT_BUS_ROLE, (Object)StandardGridRoles.HTTPD_ROLE, (Object)StandardGridRoles.SESSION_MAP_ROLE);
    }

    @Override
    public Set<Object> getFlagObjects() {
        return Collections.emptySet();
    }

    @Override
    protected String getSystemPropertiesConfigPrefix() {
        return "distributor";
    }

    @Override
    protected Config getDefaultConfig() {
        return new DefaultDistributorConfig();
    }

    @Override
    protected void execute(Config config) {
        LoggingOptions loggingOptions = new LoggingOptions(config);
        Tracer tracer = loggingOptions.getTracer();
        EventBusOptions events = new EventBusOptions(config);
        EventBus bus = events.getEventBus();
        NetworkOptions networkOptions = new NetworkOptions(config);
        HttpClient.Factory clientFactory = networkOptions.getHttpClientFactory(tracer);
        SessionMap sessions = new SessionMapOptions(config).getSessionMap();
        BaseServerOptions serverOptions = new BaseServerOptions(config);
        LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, serverOptions.getRegistrationSecret());
        Route handler = Route.combine((Routable)distributor, (Routable[])new Routable[]{Route.matching(req -> HttpMethod.GET.equals((Object)req.getMethod()) && "/status".equals(req.getUri())).to(() -> req -> (HttpResponse)new HttpResponse().setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"ready", (Object)true, (Object)"message", (Object)"Distributor is ready")))))});
        NettyServer server = new NettyServer(serverOptions, (HttpHandler)handler);
        server.start();
        BuildInfo info = new BuildInfo();
        LOG.info(String.format("Started Selenium distributor %s (revision %s): %s", info.getReleaseLabel(), info.getBuildRevision(), server.getUrl()));
    }
}

