/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.config.Configs;
import org.openqa.selenium.grid.config.DescribedOption;
import org.openqa.selenium.grid.config.HasRoles;
import org.openqa.selenium.grid.config.MapConfig;
import org.openqa.selenium.grid.config.Role;
import org.openqa.selenium.grid.config.StandardGridRoles;
import org.openqa.selenium.json.Json;

public class ConfigFlags
implements HasRoles {
    private static final ImmutableSet<String> IGNORED_SECTIONS = ImmutableSet.of((Object)"java", (Object)"lc", (Object)"term");
    @Parameter(names={"--config"}, description="Config file to read from (may be specified more than once)")
    private List<Path> configFiles;
    @Parameter(names={"--dump-config"}, description="Dump the config of the server as JSON.", hidden=true)
    private boolean dumpConfig;
    @Parameter(names={"--config-help"}, description="Output detailed information about config options")
    private boolean dumpConfigHelp;

    @Override
    public Set<Role> getRoles() {
        return StandardGridRoles.ALL_ROLES;
    }

    public Config readConfigFiles() {
        if (this.configFiles == null || this.configFiles.isEmpty()) {
            return new MapConfig((Map<String, Object>)ImmutableMap.of());
        }
        return new CompoundConfig((Config[])this.configFiles.stream().map(Configs::from).toArray(Config[]::new));
    }

    public boolean dumpConfig(Config config, PrintStream dumpTo) {
        if (!this.dumpConfig) {
            return false;
        }
        TreeMap toOutput = new TreeMap();
        for (String section : config.getSectionNames()) {
            if (section.isEmpty() || IGNORED_SECTIONS.contains((Object)section)) continue;
            config.getOptions(section).forEach(option -> config.get(section, (String)option).ifPresent(value -> toOutput.computeIfAbsent(section, ignored -> new TreeMap()).put(option, value)));
        }
        dumpTo.print(new Json().toJson(toOutput));
        return true;
    }

    public boolean dumpConfigHelp(Config config, Set<Role> currentRoles, PrintStream dumpTo) {
        if (!this.dumpConfigHelp) {
            return false;
        }
        Map<String, Set> allOptions = DescribedOption.findAllMatchingOptions(currentRoles).stream().collect(Collectors.toMap(DescribedOption::section, ImmutableSortedSet::of, (l, r) -> ImmutableSortedSet.naturalOrder().addAll((Iterable)l).addAll((Iterable)r).build()));
        StringBuilder demoToml = new StringBuilder();
        allOptions.forEach((section, options) -> {
            demoToml.append("[").append((String)section).append("]\n");
            options.forEach(option -> {
                if (!option.optionName.isEmpty()) {
                    demoToml.append("# ").append(option.description).append("\n");
                }
                demoToml.append("# Type: ").append(option.type).append("\n");
                demoToml.append(option.optionName).append(" = ").append(option.example(config)).append("\n\n");
            });
            demoToml.append("\n");
        });
        dumpTo.print(demoToml);
        return true;
    }
}

