/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.events.Event;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.events.Type;
import org.openqa.selenium.events.zeromq.UnboundZmqEventBus;
import org.openqa.selenium.net.NetworkUtils;
import org.zeromq.SocketType;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

class BoundZmqEventBus
implements EventBus {
    public static final Logger LOG = Logger.getLogger(EventBus.class.getName());
    private final UnboundZmqEventBus delegate;
    private final ZMQ.Socket xpub;
    private final ZMQ.Socket xsub;
    private final ExecutorService executor;

    BoundZmqEventBus(ZContext context, String publishConnection, String subscribeConnection) {
        String address = new NetworkUtils().getHostAddress();
        Addresses xpubAddr = this.deriveAddresses(address, publishConnection);
        Addresses xsubAddr = this.deriveAddresses(address, subscribeConnection);
        LOG.info(String.format("XPUB binding to %s, XSUB binding to %s", xpubAddr, xsubAddr));
        this.xpub = context.createSocket(SocketType.XPUB);
        this.xpub.setIPv6(xpubAddr.isIPv6);
        this.xpub.setImmediate(true);
        this.xpub.bind(xpubAddr.bindTo);
        this.xsub = context.createSocket(SocketType.XSUB);
        this.xsub.setIPv6(xsubAddr.isIPv6);
        this.xsub.setImmediate(true);
        this.xsub.bind(xsubAddr.bindTo);
        this.executor = Executors.newCachedThreadPool(r -> {
            Thread thread = new Thread(r, "Message Bus Proxy");
            thread.setDaemon(true);
            return thread;
        });
        this.executor.submit(() -> ZMQ.proxy((ZMQ.Socket)this.xsub, (ZMQ.Socket)this.xpub, null));
        this.delegate = new UnboundZmqEventBus(context, xpubAddr.advertise, xsubAddr.advertise);
        LOG.info("Event bus ready");
    }

    @Override
    public void addListener(Type type, Consumer<Event> onType) {
        this.delegate.addListener(type, onType);
    }

    @Override
    public void fire(Event event) {
        this.delegate.fire(event);
    }

    @Override
    public void close() {
        this.delegate.close();
        this.executor.shutdown();
        this.xsub.close();
        this.xpub.close();
    }

    private Addresses deriveAddresses(String host, String connection) {
        if (connection.startsWith("inproc:")) {
            return new Addresses(connection, connection, false);
        }
        if (!connection.startsWith("tcp://")) {
            throw new IllegalArgumentException("Connection string must begin with inproc:// or tcp://");
        }
        int length = "tcp://".length();
        int colon = connection.indexOf(":", length);
        if (colon == -1) {
            throw new IllegalArgumentException("Unable to determine hostname from " + connection);
        }
        String hostName = connection.substring(length, colon);
        int port = Integer.parseInt(connection.substring(colon + 1));
        if (!"*".equals(hostName)) {
            host = hostName;
        }
        boolean isAddressIPv6 = false;
        try {
            if (InetAddress.getByName(host) instanceof Inet6Address) {
                isAddressIPv6 = true;
                if (!host.startsWith("[")) {
                    host = String.format("[%s]", host);
                }
            }
        }
        catch (UnknownHostException e) {
            LOG.log(Level.WARNING, "Could not determine if host address is IPv6 or IPv4", e);
        }
        return new Addresses(connection, String.format("tcp://%s:%d", host, port), isAddressIPv6);
    }

    private static class Addresses {
        String bindTo;
        String advertise;
        boolean isIPv6;

        Addresses(String bindTo, String advertise, boolean isIPv6) {
            this.bindTo = bindTo;
            this.advertise = advertise;
            this.isIPv6 = isIPv6;
        }

        public String toString() {
            return String.format("[binding to %s, advertising as %s]", this.bindTo, this.advertise);
        }
    }
}

