/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.local;

import io.opentelemetry.trace.Tracer;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.remote.SessionId;

public class LocalSessionMap
extends SessionMap {
    private final EventBus bus;
    private final Map<SessionId, Session> knownSessions = new HashMap<SessionId, Session>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);

    public LocalSessionMap(Tracer tracer, EventBus bus) {
        super(tracer);
        this.bus = Objects.requireNonNull(bus);
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            SessionId id = (SessionId)event.getData((Type)((Object)SessionId.class));
            this.knownSessions.remove(id);
        });
    }

    public static SessionMap create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        return new LocalSessionMap(tracer, bus);
    }

    @Override
    public boolean add(Session session) {
        Objects.requireNonNull(session, "Session has not been set");
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.knownSessions.put(session.getId(), session);
        }
        finally {
            writeLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Session get(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Session session = this.knownSessions.get(id);
            if (session == null) {
                throw new NoSuchSessionException("Unable to find session with ID: " + id);
            }
            Session session2 = session;
            return session2;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void remove(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            this.knownSessions.remove(id);
        }
        finally {
            writeLock.unlock();
        }
    }
}

