/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTags;
import org.openqa.selenium.remote.tracing.HttpTracing;

class AddToSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final Json json;
    private final SessionMap sessions;

    AddToSessionMap(Tracer tracer, Json json, SessionMap sessions) {
        this.tracer = tracer;
        this.json = Objects.requireNonNull(json);
        this.sessions = Objects.requireNonNull(sessions);
    }

    public HttpResponse execute(HttpRequest req) {
        Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessions.add_session").startSpan();
        try {
            HttpResponse httpResponse;
            block9: {
                Scope scope = this.tracer.withSpan(span);
                try {
                    HttpTags.HTTP_REQUEST.accept(span, req);
                    Session session = (Session)this.json.toType(Contents.string((HttpMessage)req), Session.class);
                    Objects.requireNonNull(session, "Session to add must be set");
                    RemoteTags.SESSION_ID.accept(span, session.getId());
                    RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
                    span.setAttribute("session.uri", session.getUri().toString());
                    this.sessions.add(session);
                    httpResponse = (HttpResponse)new HttpResponse().setContent(Contents.utf8String((CharSequence)this.json.toJson((Object)ImmutableMap.of((Object)"value", (Object)true))));
                    if (scope == null) break block9;
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                scope.close();
            }
            return httpResponse;
        }
        finally {
            span.end();
        }
    }
}

