/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.local;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.lang.reflect.Type;
import java.net.URI;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.concurrent.Regularly;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.component.HealthCheck;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionClosedEvent;
import org.openqa.selenium.grid.node.ActiveSession;
import org.openqa.selenium.grid.node.CapabilityResponseEncoder;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.node.SessionFactory;
import org.openqa.selenium.grid.node.local.SessionSlot;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.HttpSessionId;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class LocalNode
extends Node {
    public static final Json JSON = new Json();
    private final URI externalUri;
    private final HealthCheck healthCheck;
    private final int maxSessionCount;
    private final List<SessionSlot> factories;
    private final Cache<SessionId, SessionSlot> currentSessions;
    private final Regularly regularly;
    private final String registrationSecret;

    private LocalNode(Tracer tracer, EventBus bus, URI uri, HealthCheck healthCheck, int maxSessionCount, Ticker ticker, Duration sessionTimeout, List<SessionSlot> factories, String registrationSecret) {
        super(tracer, UUID.randomUUID(), uri);
        Preconditions.checkArgument((maxSessionCount > 0 ? 1 : 0) != 0, (Object)("Only a positive number of sessions can be run: " + maxSessionCount));
        this.externalUri = Objects.requireNonNull(uri);
        this.healthCheck = Objects.requireNonNull(healthCheck);
        this.maxSessionCount = Math.min(maxSessionCount, factories.size());
        this.factories = ImmutableList.copyOf(factories);
        this.registrationSecret = registrationSecret;
        this.currentSessions = CacheBuilder.newBuilder().expireAfterAccess(sessionTimeout).ticker(ticker).removalListener(notification -> {
            if (!notification.wasEvicted()) {
                return;
            }
            this.killSession((SessionSlot)notification.getValue());
        }).build();
        this.regularly = new Regularly("Local Node: " + this.externalUri);
        this.regularly.submit(() -> this.currentSessions.cleanUp(), Duration.ofSeconds(30L), Duration.ofSeconds(30L));
        bus.addListener(SessionClosedEvent.SESSION_CLOSED, event -> {
            try {
                this.stop((SessionId)event.getData((Type)((Object)SessionId.class)));
            }
            catch (NoSuchSessionException noSuchSessionException) {
                // empty catch block
            }
        });
    }

    @VisibleForTesting
    public int getCurrentSessionCount() {
        return Math.toIntExact(this.currentSessions.size());
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.factories.parallelStream().anyMatch(factory -> factory.test(capabilities));
    }

    @Override
    public Optional<CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        Span span = this.tracer.getCurrentSpan();
        Logger.getLogger(LocalNode.class.getName()).info("Creating new session using span: " + span);
        Objects.requireNonNull(sessionRequest, "Session request has not been set.");
        if (span != null) {
            span.setAttribute("session_count", (long)this.getCurrentSessionCount());
        }
        if (this.getCurrentSessionCount() >= this.maxSessionCount) {
            return Optional.empty();
        }
        Optional<Object> possibleSession = Optional.empty();
        SessionSlot slot = null;
        for (SessionSlot factory : this.factories) {
            if (!factory.isAvailable() || !factory.test(sessionRequest.getCapabilities()) || !(possibleSession = factory.apply(sessionRequest)).isPresent()) continue;
            slot = factory;
            break;
        }
        if (!possibleSession.isPresent()) {
            return Optional.empty();
        }
        ActiveSession session = (ActiveSession)possibleSession.get();
        this.currentSessions.put((Object)session.getId(), slot);
        if (span != null) {
            RemoteTags.SESSION_ID.accept(span, session.getId());
            RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
            span.setAttribute("session.downstream.dialect", session.getDownstreamDialect().toString());
            span.setAttribute("session.upstream.dialect", session.getUpstreamDialect().toString());
            span.setAttribute("session.uri", session.getUri().toString());
        }
        Session externalSession = this.createExternalSession(session, this.externalUri);
        return Optional.of(new CreateSessionResponse(externalSession, (byte[])CapabilityResponseEncoder.getEncoder(session.getDownstreamDialect()).apply(externalSession)));
    }

    @Override
    protected boolean isSessionOwner(SessionId id) {
        Objects.requireNonNull(id, "Session ID has not been set");
        return this.currentSessions.getIfPresent((Object)id) != null;
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        return this.createExternalSession(slot.getSession(), this.externalUri);
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        SessionId id = HttpSessionId.getSessionId((String)req.getUri()).map(SessionId::new).orElseThrow(() -> new NoSuchSessionException("Cannot find session: " + req));
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        HttpResponse toReturn = slot.execute(req);
        if (req.getMethod() == HttpMethod.DELETE && req.getUri().equals("/session/" + id)) {
            this.stop(id);
        }
        return toReturn;
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Objects.requireNonNull(id, "Session ID has not been set");
        SessionSlot slot = (SessionSlot)this.currentSessions.getIfPresent((Object)id);
        if (slot == null) {
            throw new NoSuchSessionException("Cannot find session with id: " + id);
        }
        this.killSession(slot);
    }

    private Session createExternalSession(ActiveSession other, URI externalUri) {
        return new Session(other.getId(), externalUri, other.getCapabilities());
    }

    private void killSession(SessionSlot slot) {
        this.currentSessions.invalidate((Object)slot.getSession().getId());
        if (!slot.isAvailable()) {
            slot.stop();
        }
    }

    @Override
    public NodeStatus getStatus() {
        Map<Capabilities, Integer> stereotypes = this.factories.stream().collect(Collectors.groupingBy(SessionSlot::getStereotype, Collectors.summingInt(caps -> 1)));
        ImmutableSet activeSessions = (ImmutableSet)this.currentSessions.asMap().values().stream().map(slot -> new NodeStatus.Active(slot.getStereotype(), slot.getSession().getId(), slot.getSession().getCapabilities())).collect(ImmutableSet.toImmutableSet());
        return new NodeStatus(this.getId(), this.externalUri, this.maxSessionCount, stereotypes, (Collection<NodeStatus.Active>)activeSessions, this.registrationSecret);
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    private Map<String, Object> toJson() {
        return ImmutableMap.of((Object)"id", (Object)this.getId(), (Object)"uri", (Object)this.externalUri, (Object)"maxSessions", (Object)this.maxSessionCount, (Object)"capabilities", this.factories.stream().map(SessionSlot::getStereotype).collect(Collectors.toSet()));
    }

    public static Builder builder(Tracer tracer, EventBus bus, HttpClient.Factory httpClientFactory, URI uri, String registrationSecret) {
        return new Builder(tracer, bus, httpClientFactory, uri, registrationSecret);
    }

    public static class Builder {
        private final Tracer tracer;
        private final EventBus bus;
        private final HttpClient.Factory httpClientFactory;
        private final URI uri;
        private final String registrationSecret;
        private final ImmutableList.Builder<SessionSlot> factories;
        private int maxCount = Runtime.getRuntime().availableProcessors() * 5;
        private Ticker ticker = Ticker.systemTicker();
        private Duration sessionTimeout = Duration.ofMinutes(5L);
        private HealthCheck healthCheck;

        public Builder(Tracer tracer, EventBus bus, HttpClient.Factory httpClientFactory, URI uri, String registrationSecret) {
            this.tracer = Objects.requireNonNull(tracer);
            this.bus = Objects.requireNonNull(bus);
            this.httpClientFactory = Objects.requireNonNull(httpClientFactory);
            this.uri = Objects.requireNonNull(uri);
            this.registrationSecret = registrationSecret;
            this.factories = ImmutableList.builder();
        }

        public Builder add(Capabilities stereotype, SessionFactory factory) {
            Objects.requireNonNull(stereotype, "Capabilities must be set.");
            Objects.requireNonNull(factory, "Session factory must be set.");
            this.factories.add((Object)new SessionSlot(this.bus, stereotype, factory));
            return this;
        }

        public Builder maximumConcurrentSessions(int maxCount) {
            Preconditions.checkArgument((maxCount > 0 ? 1 : 0) != 0, (Object)("Only a positive number of sessions can be run: " + maxCount));
            this.maxCount = maxCount;
            return this;
        }

        public Builder sessionTimeout(Duration timeout) {
            this.sessionTimeout = timeout;
            return this;
        }

        public LocalNode build() {
            HealthCheck check = this.healthCheck == null ? () -> new HealthCheck.Result(true, this.uri + " is ok", this.registrationSecret) : this.healthCheck;
            return new LocalNode(this.tracer, this.bus, this.uri, check, this.maxCount, this.ticker, this.sessionTimeout, (List)this.factories.build(), this.registrationSecret);
        }

        public Advanced advanced() {
            return new Advanced();
        }

        public class Advanced {
            public Advanced clock(final Clock clock) {
                Builder.this.ticker = new Ticker(){

                    public long read() {
                        return clock.instant().toEpochMilli() * Duration.ofMillis(1L).toNanos();
                    }
                };
                return this;
            }

            public Advanced healthCheck(HealthCheck healthCheck) {
                Builder.this.healthCheck = Objects.requireNonNull(healthCheck, "Health check must be set.");
                return this;
            }

            public Node build() {
                return Builder.this.build();
            }
        }
    }
}

