/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.log;

import io.opentelemetry.exporters.logging.LoggingExporter;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.trace.MultiSpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdkFactory;
import io.opentelemetry.sdk.trace.export.SimpleSpansProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.trace.Tracer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Objects;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.log.FlushingHandler;
import org.openqa.selenium.grid.log.JaegerTracing;
import org.openqa.selenium.grid.log.JsonFormatter;
import org.openqa.selenium.grid.log.TerseFormatter;

public class LoggingOptions {
    private final Config config;

    public LoggingOptions(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public boolean isUsingStructuredLogging() {
        return this.config.getBool("logging", "structured-logs").orElse(false);
    }

    public boolean isUsingPlainLogs() {
        return this.config.getBool("logging", "plain-logs").orElse(true);
    }

    public Tracer getTracer() {
        TracerSdkFactory tracerFactory = OpenTelemetrySdk.getTracerFactory();
        LinkedList<SimpleSpansProcessor> exporters = new LinkedList<SimpleSpansProcessor>();
        exporters.add(SimpleSpansProcessor.newBuilder((SpanExporter)new LoggingExporter()).build());
        SpanExporter maybeJaeger = JaegerTracing.findJaegerExporter();
        if (maybeJaeger != null) {
            exporters.add(SimpleSpansProcessor.newBuilder((SpanExporter)maybeJaeger).build());
        }
        tracerFactory.addSpanProcessor(MultiSpanProcessor.create(exporters));
        return tracerFactory.get("default");
    }

    public void configureLogging() {
        FlushingHandler handler;
        Logger logger;
        if (!this.config.getBool("logging", "enable").orElse(true).booleanValue()) {
            return;
        }
        LogManager logManager = LogManager.getLogManager();
        Enumeration<String> names = logManager.getLoggerNames();
        while (names.hasMoreElements()) {
            logger = logManager.getLogger(names.nextElement());
            Arrays.stream(logger.getHandlers()).forEach(logger::removeHandler);
        }
        logger = logManager.getLogger("");
        if (this.isUsingPlainLogs()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new TerseFormatter());
            logger.addHandler(handler);
        }
        if (this.isUsingStructuredLogging()) {
            handler = new FlushingHandler(System.out);
            handler.setFormatter(new JsonFormatter());
            logger.addHandler(handler);
        }
    }
}

