/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.remote;

import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.Tracer;
import java.net.URL;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;

public class RemoteDistributor
extends Distributor {
    public static final Json JSON = new Json();
    private static final Logger LOG = Logger.getLogger("Selenium Distributor (Remote)");
    private final HttpHandler client;

    public RemoteDistributor(Tracer tracer, HttpClient.Factory factory, URL url) {
        super(tracer, factory);
        Objects.requireNonNull(factory);
        Objects.requireNonNull(url);
        this.client = factory.createClient(url);
    }

    @Override
    public CreateSessionResponse newSession(HttpRequest request) throws SessionNotCreatedException {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/session");
        Span span = this.tracer.getCurrentSpan();
        HttpTracing.inject((Tracer)this.tracer, (Span)span, (HttpRequest)upstream);
        upstream.setContent(request.getContent());
        HttpResponse response = this.client.execute(upstream);
        return (CreateSessionResponse)Values.get(response, CreateSessionResponse.class);
    }

    @Override
    public RemoteDistributor add(Node node) {
        HttpRequest request = new HttpRequest(HttpMethod.POST, "/se/grid/distributor/node");
        Span span = this.tracer.getCurrentSpan();
        HttpTracing.inject((Tracer)this.tracer, (Span)span, (HttpRequest)request);
        request.setContent(Contents.utf8String((CharSequence)JSON.toJson((Object)node.getStatus())));
        HttpResponse response = this.client.execute(request);
        Values.get(response, Void.class);
        LOG.info(String.format("Added node %s.", node.getId()));
        return this;
    }

    @Override
    public void remove(UUID nodeId) {
        Objects.requireNonNull(nodeId, "Node ID must be set");
        HttpRequest request = new HttpRequest(HttpMethod.DELETE, "/se/grid/distributor/node/" + nodeId);
        HttpTracing.inject((Tracer)this.tracer, (Span)this.tracer.getCurrentSpan(), (HttpRequest)request);
        HttpResponse response = this.client.execute(request);
        Values.get(response, Void.class);
    }

    @Override
    public DistributorStatus getStatus() {
        HttpRequest request = new HttpRequest(HttpMethod.GET, "/se/grid/distributor/status");
        Span span = this.tracer.getCurrentSpan();
        HttpTracing.inject((Tracer)this.tracer, (Span)span, (HttpRequest)request);
        HttpResponse response = this.client.execute(request);
        return (DistributorStatus)Values.get(response, DistributorStatus.class);
    }
}

