/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.commands;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import io.opentelemetry.trace.Tracer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.commands.DefaultStandaloneConfig;
import org.openqa.selenium.grid.commands.StandaloneFlags;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.local.LocalDistributor;
import org.openqa.selenium.grid.docker.DockerFlags;
import org.openqa.selenium.grid.docker.DockerOptions;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.config.NodeOptions;
import org.openqa.selenium.grid.node.local.LocalNode;
import org.openqa.selenium.grid.router.Router;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;
import org.openqa.selenium.grid.web.CombinedHandler;
import org.openqa.selenium.grid.web.RoutableHttpClientFactory;
import org.openqa.selenium.net.NetworkUtils;
import org.openqa.selenium.netty.server.NettyServer;

public class Standalone
implements CliCommand {
    private static final Logger LOG = Logger.getLogger("selenium");

    @Override
    public String getName() {
        return "standalone";
    }

    @Override
    public String getDescription() {
        return "The selenium server, running everything in-process.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags baseFlags = new BaseServerFlags(4444);
        EventBusFlags eventFlags = new EventBusFlags();
        DockerFlags dockerFlags = new DockerFlags();
        StandaloneFlags standaloneFlags = new StandaloneFlags();
        JCommander commander = JCommander.newBuilder().programName("standalone").addObject((Object)baseFlags).addObject((Object)help).addObject((Object)eventFlags).addObject((Object)dockerFlags).addObject((Object)standaloneFlags).build();
        return () -> {
            String hostName;
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("selenium", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(baseFlags), new AnnotatedConfig(dockerFlags), new AnnotatedConfig(standaloneFlags), new AnnotatedConfig(eventFlags), new DefaultStandaloneConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            Tracer tracer = loggingOptions.getTracer();
            EventBusOptions events = new EventBusOptions(config);
            EventBus bus = events.getEventBus();
            try {
                hostName = new NetworkUtils().getNonLoopbackAddressOfThisMachine();
            }
            catch (WebDriverException e) {
                hostName = "localhost";
            }
            int port = config.getInt("server", "port").orElseThrow(() -> new IllegalArgumentException("No port to use configured"));
            URI localhost = null;
            try {
                localhost = new URI("http", null, hostName, port, null, null, null);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            NetworkOptions networkOptions = new NetworkOptions(config);
            CombinedHandler combinedHandler = new CombinedHandler();
            RoutableHttpClientFactory clientFactory = new RoutableHttpClientFactory(localhost.toURL(), combinedHandler, networkOptions.getHttpClientFactory(tracer));
            LocalSessionMap sessions = new LocalSessionMap(tracer, bus);
            combinedHandler.addHandler(sessions);
            LocalDistributor distributor = new LocalDistributor(tracer, bus, clientFactory, sessions, null);
            combinedHandler.addHandler(distributor);
            Router router = new Router(tracer, clientFactory, sessions, distributor);
            LocalNode.Builder nodeBuilder = LocalNode.builder(tracer, bus, clientFactory, localhost, null).maximumConcurrentSessions(Runtime.getRuntime().availableProcessors() * 3);
            new NodeOptions(config).configure(tracer, clientFactory, nodeBuilder);
            new DockerOptions(config).configure(tracer, clientFactory, nodeBuilder);
            LocalNode node = nodeBuilder.build();
            combinedHandler.addHandler(node);
            ((Distributor)distributor).add(node);
            NettyServer server = new NettyServer(new BaseServerOptions(config), router);
            server.start();
            BuildInfo info = new BuildInfo();
            LOG.info(String.format("Started Selenium standalone %s (revision %s)", info.getReleaseLabel(), info.getBuildRevision()));
        };
    }
}

