/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.openqa.selenium.docker.Container;
import org.openqa.selenium.docker.ContainerInfo;
import org.openqa.selenium.docker.DockerException;
import org.openqa.selenium.docker.DockerProtocol;
import org.openqa.selenium.docker.Image;
import org.openqa.selenium.docker.VersionCommand;
import org.openqa.selenium.remote.http.HttpHandler;

public class Docker {
    private static final Logger LOG = Logger.getLogger(Docker.class.getName());
    protected final HttpHandler client;
    private volatile Optional<DockerProtocol> dockerClient;

    public Docker(HttpHandler client) {
        this.client = Objects.requireNonNull(client, "HTTP client to use must be set.");
        this.dockerClient = Optional.empty();
    }

    public boolean isSupported() {
        return this.getDocker().isPresent();
    }

    public String getVersion() {
        return this.getDocker().map(DockerProtocol::version).orElse("unsupported");
    }

    public Image getImage(String name) {
        Objects.requireNonNull(name, "Image name to get must be set.");
        LOG.info("Obtaining image: " + name);
        return this.getDocker().map(protocol -> protocol.getImage(name)).orElseThrow(() -> new DockerException("Unable to get image " + name));
    }

    public Container create(ContainerInfo info) {
        Objects.requireNonNull(info, "Container info must be set.");
        LOG.info("Creating image from " + info);
        return this.getDocker().map(protocol -> protocol.create(info)).orElseThrow(() -> new DockerException("Unable to create container: " + info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<DockerProtocol> getDocker() {
        if (this.dockerClient.isPresent()) {
            return this.dockerClient;
        }
        Docker docker = this;
        synchronized (docker) {
            if (!this.dockerClient.isPresent()) {
                this.dockerClient = new VersionCommand(this.client).getDockerProtocol();
            }
        }
        return this.dockerClient;
    }
}

