/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap.httpd;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.util.logging.Logger;
import org.openqa.selenium.BuildInfo;
import org.openqa.selenium.cli.CliCommand;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.AnnotatedConfig;
import org.openqa.selenium.grid.config.CompoundConfig;
import org.openqa.selenium.grid.config.ConcatenatingConfig;
import org.openqa.selenium.grid.config.EnvConfig;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.server.BaseServer;
import org.openqa.selenium.grid.server.BaseServerFlags;
import org.openqa.selenium.grid.server.BaseServerOptions;
import org.openqa.selenium.grid.server.EventBusConfig;
import org.openqa.selenium.grid.server.EventBusFlags;
import org.openqa.selenium.grid.server.HelpFlags;
import org.openqa.selenium.grid.sessionmap.httpd.DefaultSessionMapConfig;
import org.openqa.selenium.grid.sessionmap.local.LocalSessionMap;

public class SessionMapServer
implements CliCommand {
    private static final Logger LOG = Logger.getLogger(SessionMapServer.class.getName());

    @Override
    public String getName() {
        return "sessions";
    }

    @Override
    public String getDescription() {
        return "Adds this server as the session map in a selenium grid.";
    }

    @Override
    public CliCommand.Executable configure(String ... args) {
        HelpFlags help = new HelpFlags();
        BaseServerFlags serverFlags = new BaseServerFlags(5556);
        EventBusFlags eventBusFlags = new EventBusFlags();
        JCommander commander = JCommander.newBuilder().programName(this.getName()).addObject((Object)help).addObject((Object)serverFlags).addObject((Object)eventBusFlags).build();
        return () -> {
            try {
                commander.parse(args);
            }
            catch (ParameterException e) {
                System.err.println(e.getMessage());
                commander.usage();
                return;
            }
            if (help.displayHelp(commander, System.out)) {
                return;
            }
            CompoundConfig config = new CompoundConfig(new EnvConfig(), new ConcatenatingConfig("sessions", '.', System.getProperties()), new AnnotatedConfig(help), new AnnotatedConfig(serverFlags), new AnnotatedConfig(eventBusFlags), new DefaultSessionMapConfig());
            LoggingOptions loggingOptions = new LoggingOptions(config);
            loggingOptions.configureLogging();
            EventBusConfig events = new EventBusConfig(config);
            EventBus bus = events.getEventBus();
            LocalSessionMap sessions = new LocalSessionMap(bus);
            BaseServerOptions serverOptions = new BaseServerOptions(config);
            BaseServer server = new BaseServer(serverOptions);
            server.setHandler(sessions);
            server.start();
            BuildInfo info = new BuildInfo();
            LOG.info(String.format("Started Selenium session map %s (revision %s)", info.getReleaseLabel(), info.getBuildRevision()));
        };
    }
}

