/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.docker;

import java.util.Objects;
import java.util.function.Predicate;
import org.openqa.selenium.docker.Image;

public class ImageNamePredicate
implements Predicate<Image> {
    private final String name;
    private final String tag;

    public ImageNamePredicate(String name, String tag) {
        this.name = Objects.requireNonNull(name);
        this.tag = Objects.requireNonNull(tag);
    }

    public ImageNamePredicate(String name) {
        Objects.requireNonNull(name);
        int index = name.indexOf(":");
        if (index == -1) {
            this.tag = "latest";
            this.name = name;
        } else {
            this.name = name.substring(0, index);
            this.tag = name.substring(index + 1);
        }
    }

    @Override
    public boolean test(Image image) {
        return image.getTags().contains(this.name + ":" + this.tag);
    }

    public String toString() {
        return "by tag: " + this.name + ":" + this.tag;
    }
}

