/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxOptions {
    public static final String FIREFOX_OPTIONS = "moz:firefoxOptions";
    private static final Logger LOG = Logger.getLogger(FirefoxOptions.class.getName());
    private String binaryPath;
    private FirefoxBinary actualBinary;
    private FirefoxProfile profile;
    private List<String> args = new ArrayList<String>();
    private Map<String, Boolean> booleanPrefs = new HashMap<String, Boolean>();
    private Map<String, Integer> intPrefs = new HashMap<String, Integer>();
    private Map<String, String> stringPrefs = new HashMap<String, String>();
    private Level logLevel = null;
    private boolean legacy;
    private DesiredCapabilities desiredCapabilities = new DesiredCapabilities();

    static FirefoxOptions fromJsonMap(Map<String, Object> map) throws IOException {
        FirefoxOptions options = new FirefoxOptions();
        if (map.containsKey("binary")) {
            options.setBinary(FirefoxOptions.getOption(map, "binary", String.class));
        }
        if (map.containsKey("args")) {
            List list = FirefoxOptions.getOption(map, "args", List.class);
            options.addArguments(list);
        }
        if (map.containsKey("profile")) {
            Object value2 = map.get("profile");
            if (value2 instanceof String) {
                options.setProfile(FirefoxProfile.fromJson((String)value2));
            } else if (value2 instanceof FirefoxProfile) {
                options.setProfile((FirefoxProfile)value2);
            } else {
                throw new WebDriverException("In FirefoxOptions, don't know how to convert profile: " + map);
            }
        }
        if (map.containsKey("prefs")) {
            Map prefs = FirefoxOptions.getOption(map, "prefs", Map.class);
            prefs.forEach((key, value) -> {
                if (value instanceof Boolean) {
                    options.addPreference((String)key, (Boolean)value);
                } else if (value instanceof Integer || value instanceof Long) {
                    options.addPreference((String)key, ((Number)value).intValue());
                } else if (value instanceof String) {
                    options.addPreference((String)key, (String)value);
                } else {
                    throw new WebDriverException("Invalid Firefox preference value: " + key + "=" + value);
                }
            });
        }
        return options;
    }

    private static <T> T getOption(Map<String, Object> map, String key, Class<T> type) {
        Object value = map.get(key);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new WebDriverException(String.format("In FirefoxOptions, expected key '%s' to be a %s: %s", key, type.getSimpleName(), map));
    }

    public FirefoxOptions() {
        String profileName;
        String forceMarionette;
        String binary = System.getProperty("webdriver.firefox.bin");
        if (binary != null) {
            this.setBinary(binary);
        }
        if ((forceMarionette = System.getProperty("webdriver.firefox.marionette")) != null) {
            this.setLegacy(!Boolean.getBoolean("webdriver.firefox.marionette"));
        }
        if ((profileName = System.getProperty("webdriver.firefox.profile")) != null) {
            this.profile = new ProfilesIni().getProfile(profileName);
            if (this.profile == null) {
                throw new WebDriverException(String.format("Firefox profile '%s' named in system property '%s' not found", profileName, "webdriver.firefox.profile"));
            }
        }
    }

    public FirefoxOptions setLegacy(boolean legacy) {
        this.legacy = legacy;
        this.desiredCapabilities.setCapability("marionette", !legacy);
        return this;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public FirefoxOptions setBinary(FirefoxBinary binary) {
        this.actualBinary = (FirefoxBinary)Preconditions.checkNotNull((Object)binary);
        binary.amendOptions(this);
        this.desiredCapabilities.setCapability("firefox_binary", (Object)binary);
        this.binaryPath = null;
        return this;
    }

    public FirefoxOptions setBinary(Path path) {
        this.binaryPath = this.toForwardSlashes(path);
        this.actualBinary = null;
        if (Files.exists(path, new LinkOption[0])) {
            this.desiredCapabilities.setCapability("firefox_binary", (Object)new FirefoxBinary(path.toFile()));
        }
        return this;
    }

    private String toForwardSlashes(Path path) {
        return ((Path)Preconditions.checkNotNull((Object)path)).toString().replace('\\', '/');
    }

    public FirefoxOptions setBinary(String path) {
        return this.setBinary(Paths.get((String)Preconditions.checkNotNull((Object)path), new String[0]));
    }

    public FirefoxBinary getBinary() {
        return this.getBinaryOrNull().orElseGet(FirefoxBinary::new);
    }

    public Optional<FirefoxBinary> getBinaryOrNull() {
        if (this.actualBinary != null) {
            return Optional.of(this.actualBinary);
        }
        if (this.binaryPath != null) {
            return Optional.of(new FirefoxBinary(new File(this.binaryPath)));
        }
        return Stream.of(this.desiredCapabilities).map(this::determineBinaryFromCapabilities).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }

    private Optional<FirefoxBinary> determineBinaryFromCapabilities(Capabilities caps) {
        if (caps.getCapability("firefox_binary") != null) {
            Object raw = caps.getCapability("firefox_binary");
            if (raw instanceof FirefoxBinary) {
                return Optional.of((FirefoxBinary)raw);
            }
            try {
                return Optional.of(new FirefoxBinary(new File(raw.toString())));
            }
            catch (WebDriverException wde) {
                throw new SessionNotCreatedException(wde.getMessage());
            }
        }
        Object rawVersion = caps.getCapability("version");
        if (rawVersion != null && !"".equals(rawVersion)) {
            FirefoxBinary.Channel channel = FirefoxBinary.Channel.fromString(String.valueOf(rawVersion));
            return Optional.of(new FirefoxBinary(channel));
        }
        return Optional.empty();
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        this.profile = profile;
        if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
            LOG.info("Will update profile with preferences from these options.");
            this.booleanPrefs.forEach(profile::setPreference);
            this.intPrefs.forEach(profile::setPreference);
            this.stringPrefs.forEach(profile::setPreference);
        }
        this.desiredCapabilities.setCapability("firefox_profile", (Object)profile);
        return this;
    }

    public FirefoxProfile getProfile() {
        return this.getProfileOrNull().orElseGet(() -> this.fullyPopulateProfile(new FirefoxProfile()));
    }

    @VisibleForTesting
    Optional<FirefoxProfile> getProfileOrNull() {
        FirefoxProfile profileToUse = this.profile;
        if (profileToUse == null) {
            profileToUse = this.extractProfile((Capabilities)this.desiredCapabilities);
        }
        if (profileToUse == null) {
            return Optional.empty();
        }
        return Optional.of(this.fullyPopulateProfile(profileToUse));
    }

    private FirefoxProfile fullyPopulateProfile(FirefoxProfile profile) {
        FirefoxOptions.populateProfile(profile, (Capabilities)this.desiredCapabilities);
        this.booleanPrefs.forEach(profile::setPreference);
        this.intPrefs.forEach(profile::setPreference);
        this.stringPrefs.forEach(profile::setPreference);
        return profile;
    }

    private static void populateProfile(FirefoxProfile profile, Capabilities capabilities) {
        Preconditions.checkNotNull((Object)profile);
        if (capabilities == null) {
            return;
        }
        if (capabilities.getCapability("webStorageEnabled") != null) {
            Boolean supportsWebStorage = (Boolean)capabilities.getCapability("webStorageEnabled");
            profile.setPreference("dom.storage.enabled", supportsWebStorage);
        }
        if (capabilities.getCapability("acceptSslCerts") != null) {
            Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
            profile.setAcceptUntrustedCertificates(acceptCerts);
        }
        if (capabilities.getCapability("loggingPrefs") != null) {
            LoggingPreferences logsPrefs = (LoggingPreferences)capabilities.getCapability("loggingPrefs");
            for (String logtype : logsPrefs.getEnabledLogTypes()) {
                profile.setPreference("webdriver.log." + logtype, logsPrefs.getLevel(logtype).intValue());
            }
        }
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public FirefoxOptions addPreference(String key, boolean value) {
        this.booleanPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        if (this.profile != null) {
            this.profile.setPreference(key, value);
        }
        return this;
    }

    public FirefoxOptions addPreference(String key, int value) {
        this.intPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        if (this.profile != null) {
            this.profile.setPreference(key, value);
        }
        return this;
    }

    public FirefoxOptions addPreference(String key, String value) {
        this.stringPrefs.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
        if (this.profile != null) {
            this.profile.setPreference(key, value);
        }
        return this;
    }

    public FirefoxOptions setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Deprecated
    public FirefoxOptions addDesiredCapabilities(Capabilities desiredCapabilities) {
        return this.addCapabilities(desiredCapabilities);
    }

    @Deprecated
    public FirefoxOptions addRequiredCapabilities(Capabilities requiredCapabilities) {
        return this.addCapabilities(requiredCapabilities);
    }

    public FirefoxOptions addCapabilities(Capabilities capabilities) {
        return this.validateAndAmendUsing(this.desiredCapabilities, capabilities);
    }

    private FirefoxOptions validateAndAmendUsing(DesiredCapabilities existing, Capabilities caps) {
        Object rawMarionette;
        Object binary;
        if (caps == null) {
            return this;
        }
        existing.merge(caps);
        FirefoxProfile newProfile = this.extractProfile(caps);
        if (this.profile != null && newProfile != null && !this.profile.equals(newProfile)) {
            LOG.info("Found a profile on these options and the capabilities. Will assume you want the profile already set here. If you're seeing this in the logs of the standalone server, we've probably just deserialized the same options twice and it's likely that there's nothing to worry about.");
        }
        if (newProfile != null) {
            this.setProfile(newProfile);
        }
        if ((binary = existing.getCapability("firefox_binary")) != null) {
            if (binary instanceof File) {
                this.setBinary(((File)binary).toPath());
            } else if (binary instanceof FirefoxBinary) {
                this.setBinary((FirefoxBinary)binary);
            } else if (binary instanceof Path) {
                this.setBinary((Path)binary);
            } else if (binary instanceof String) {
                this.setBinary((String)binary);
            }
        }
        if ((rawMarionette = existing.getCapability("marionette")) instanceof Boolean) {
            this.setLegacy((Boolean)rawMarionette == false);
        }
        return this;
    }

    private FirefoxProfile extractProfile(Capabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        Object raw = capabilities.getCapability("firefox_profile");
        if (raw == null) {
            return null;
        }
        if (raw instanceof FirefoxProfile) {
            return (FirefoxProfile)raw;
        }
        if (raw instanceof String) {
            try {
                return FirefoxProfile.fromJson((String)raw);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return null;
    }

    public Capabilities toDesiredCapabilities() {
        return this.toCapabilities((Capabilities)this.desiredCapabilities);
    }

    public Capabilities toRequiredCapabilities() {
        return this.toCapabilities((Capabilities)this.desiredCapabilities);
    }

    public Capabilities toCapabilities() {
        return this.toCapabilities((Capabilities)this.desiredCapabilities);
    }

    private Capabilities toCapabilities(Capabilities source) {
        Object priorBinary;
        HashMap<String, Object> caps = new HashMap<String, Object>(source.asMap());
        if (this.isLegacy()) {
            caps.put("marionette", false);
        }
        if ((priorBinary = source.getCapability("firefox_binary")) instanceof Path) {
            priorBinary = this.toForwardSlashes((Path)priorBinary);
        }
        if (priorBinary instanceof String) {
            priorBinary = this.toForwardSlashes(Paths.get((String)priorBinary, new String[0]));
        }
        if (priorBinary instanceof FirefoxBinary) {
            priorBinary = this.toForwardSlashes(((FirefoxBinary)priorBinary).getFile().toPath());
        }
        if (this.actualBinary != null && !this.actualBinary.getFile().toPath().equals(priorBinary) || this.binaryPath != null && !this.binaryPath.equals(priorBinary)) {
            LOG.info(String.format("Preferring the firefox binary in these options (%s rather than %s)", this.actualBinary != null ? this.actualBinary.getPath() : this.binaryPath, priorBinary));
        }
        if (this.actualBinary != null && this.binaryPath == null) {
            caps.put("firefox_binary", this.actualBinary);
        } else if (this.binaryPath != null && this.actualBinary == null && Files.exists(Paths.get(this.binaryPath, new String[0]), new LinkOption[0])) {
            caps.put("firefox_binary", new FirefoxBinary(new File(this.binaryPath)));
        }
        Object priorProfile = source.getCapability("firefox_profile");
        if (priorProfile instanceof String) {
            try {
                priorProfile = FirefoxProfile.fromJson((String)priorProfile);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        if (priorProfile != null) {
            if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
                LOG.info("Setting our our preferences on the existing profile");
            }
            if (this.profile != null && !priorProfile.equals(this.profile)) {
                LOG.info("Found a profile on these options and the capabilities. Will assume you want the profile already set here. If you're seeing this in the logs of the standalone server, we've probably just deserialized the same options twice and it's likely that there's nothing to worry about.");
            }
            if (this.profile == null) {
                if (priorProfile instanceof FirefoxProfile) {
                    this.profile = (FirefoxProfile)priorProfile;
                } else {
                    LOG.info("Unable to use profile: " + priorProfile.getClass());
                }
            }
        }
        caps.put(FIREFOX_OPTIONS, this);
        if (this.actualBinary != null) {
            this.actualBinary.addCommandLineOptions(this.args.toArray(new String[this.args.size()]));
            caps.put("firefox_binary", this.actualBinary);
        }
        if (this.binaryPath != null) {
            caps.put("firefox_binary", this.binaryPath);
        }
        if (this.profile != null) {
            caps.put("firefox_profile", this.profile);
        }
        return new ImmutableCapabilities(caps);
    }

    public DesiredCapabilities addTo(DesiredCapabilities capabilities) {
        return capabilities.merge(this.toCapabilities());
    }

    public JsonObject toJson() throws IOException {
        JsonObject options = new JsonObject();
        if (this.actualBinary != null) {
            options.addProperty("binary", this.actualBinary.getPath());
        } else if (this.binaryPath != null) {
            options.addProperty("binary", this.binaryPath);
        }
        if (this.profile != null) {
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Comparable<Boolean>> entry : this.intPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (Integer)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.stringPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (String)entry.getValue());
            }
            options.addProperty("profile", this.profile.toJson());
        } else {
            JsonObject allPrefs = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            for (Map.Entry<String, Integer> entry : this.intPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive((Number)entry.getValue()));
            }
            for (Map.Entry<String, String> entry : this.stringPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            options.add("prefs", (JsonElement)allPrefs);
        }
        if (this.logLevel != null) {
            JsonObject level = new JsonObject();
            level.add("level", (JsonElement)new JsonPrimitive(this.logLevelToGeckoLevel()));
            options.add("log", (JsonElement)level);
        }
        JsonArray arguments = new JsonArray();
        for (String string : this.args) {
            arguments.add((JsonElement)new JsonPrimitive(string));
        }
        options.add("args", (JsonElement)arguments);
        return options;
    }

    private String logLevelToGeckoLevel() {
        if (this.logLevel.intValue() < Level.FINE.intValue()) {
            return "trace";
        }
        if (this.logLevel == Level.FINE) {
            return "debug";
        }
        if (this.logLevel == Level.CONFIG) {
            return "config";
        }
        if (this.logLevel == Level.INFO) {
            return "info";
        }
        if (this.logLevel == Level.WARNING) {
            return "warn";
        }
        if (this.logLevel == Level.SEVERE) {
            return "error";
        }
        if (this.logLevel == Level.OFF) {
            return "fatal";
        }
        return "debug";
    }

    public String toString() {
        return "{binary=" + this.getBinaryOrNull() + ", args=" + this.args + ", legacy=" + this.legacy + ", logLevel=" + this.logLevel + ", prefs=" + Stream.of(this.booleanPrefs, this.intPrefs, this.stringPrefs).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()))) + ", profile=" + this.profile + "}";
    }
}

