/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.firefox.internal.NewProfileExtensionConnection;
import org.openqa.selenium.internal.Killable;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.internal.SocketLock;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class FirefoxDriver
extends RemoteWebDriver
implements Killable {
    public static final String BINARY = "firefox_binary";
    public static final String PROFILE = "firefox_profile";
    public static final String MARIONETTE = "marionette";
    @Deprecated
    public static final boolean ACCEPT_UNTRUSTED_CERTIFICATES = true;
    @Deprecated
    public static final boolean ASSUME_UNTRUSTED_ISSUER = true;
    protected FirefoxBinary binary;

    public FirefoxDriver() {
        this(new FirefoxOptions());
    }

    public FirefoxDriver(FirefoxOptions options) {
        this(FirefoxDriver.toExecutor(options), options.toDesiredCapabilities(), options.toRequiredCapabilities());
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary) {
        this(new FirefoxOptions().setBinary(binary));
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxOptions().setProfile(profile));
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        this(new FirefoxOptions().setBinary(binary).setProfile(profile));
    }

    public FirefoxDriver(Capabilities desiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).addDesiredCapabilities(desiredCapabilities));
    }

    public FirefoxDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).addDesiredCapabilities(desiredCapabilities).addRequiredCapabilities(requiredCapabilities));
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities capabilities) {
        this(FirefoxDriver.getFirefoxOptions(capabilities).setBinary(binary).setProfile(profile).addDesiredCapabilities(capabilities));
    }

    @Deprecated
    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this(FirefoxDriver.getFirefoxOptions(desiredCapabilities).setBinary(binary).setProfile(profile).addDesiredCapabilities(desiredCapabilities).addRequiredCapabilities(requiredCapabilities));
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService driverService) {
        this((CommandExecutor)new DriverCommandExecutor((DriverService)driverService), null, null);
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService driverService, Capabilities desiredCapabilities) {
        this((CommandExecutor)new DriverCommandExecutor((DriverService)driverService), desiredCapabilities, null);
    }

    @Deprecated
    public FirefoxDriver(GeckoDriverService driverService, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        this((CommandExecutor)new DriverCommandExecutor((DriverService)driverService), desiredCapabilities, requiredCapabilities);
    }

    private FirefoxDriver(CommandExecutor executor, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(executor, FirefoxDriver.dropCapabilities(desiredCapabilities), FirefoxDriver.dropCapabilities(requiredCapabilities));
    }

    private static CommandExecutor toExecutor(FirefoxOptions options) {
        if (options.isLegacy()) {
            return new LazyCommandExecutor(options.getBinary(), options.getProfile());
        }
        GeckoDriverService.Builder builder = (GeckoDriverService.Builder)new GeckoDriverService.Builder().usingPort(0);
        Optional<FirefoxBinary> binary = options.getBinaryOrNull();
        if (binary.isPresent()) {
            builder.usingFirefoxBinary(binary.get());
        }
        return new DriverCommandExecutor(builder.build());
    }

    private static FirefoxOptions getFirefoxOptions(Capabilities capabilities) {
        FirefoxOptions options = new FirefoxOptions();
        if (capabilities == null) {
            return options;
        }
        Object rawOptions = capabilities.getCapability("moz:firefoxOptions");
        if (rawOptions != null) {
            if (rawOptions instanceof Map) {
                try {
                    Map map = (Map)rawOptions;
                    rawOptions = FirefoxOptions.fromJsonMap(map);
                }
                catch (IOException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            if (rawOptions != null && !(rawOptions instanceof FirefoxOptions)) {
                throw new WebDriverException("Firefox option was set, but is not a FirefoxOption: " + rawOptions);
            }
            options = (FirefoxOptions)rawOptions;
        }
        return options;
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public void kill() {
        if (this.getCommandExecutor() instanceof LazyCommandExecutor) {
            ((LazyCommandExecutor)this.getCommandExecutor()).binary.quit();
        }
    }

    public WebDriver.Options manage() {
        return new RemoteWebDriver.RemoteWebDriverOptions(){

            public WebDriver.Timeouts timeouts() {
                return new RemoteWebDriver.RemoteWebDriverOptions.RemoteTimeouts(){

                    public WebDriver.Timeouts implicitlyWait(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"implicit", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }

                    public WebDriver.Timeouts setScriptTimeout(long time, TimeUnit unit) {
                        FirefoxDriver.this.execute("setTimeout", (Map)ImmutableMap.of((Object)"type", (Object)"script", (Object)"ms", (Object)TimeUnit.MILLISECONDS.convert(time, unit)));
                        return this;
                    }
                };
            }
        };
    }

    private static boolean isLegacy(Capabilities desiredCapabilities) {
        Boolean forceMarionette = FirefoxDriver.forceMarionetteFromSystemProperty();
        if (forceMarionette != null) {
            return forceMarionette == false;
        }
        Object marionette = desiredCapabilities.getCapability(MARIONETTE);
        return marionette instanceof Boolean && (Boolean)marionette == false;
    }

    private static Boolean forceMarionetteFromSystemProperty() {
        String useMarionette = System.getProperty("webdriver.firefox.marionette");
        if (useMarionette == null) {
            return null;
        }
        return Boolean.valueOf(useMarionette);
    }

    protected void startClient(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        if (FirefoxDriver.isLegacy(desiredCapabilities)) {
            LazyCommandExecutor exe = (LazyCommandExecutor)this.getCommandExecutor();
            ExtensionConnection connection = this.connectTo(exe.binary, exe.profile, "localhost");
            exe.setConnection(connection);
            try {
                connection.start();
            }
            catch (IOException e) {
                throw new WebDriverException("An error occurred while connecting to Firefox", (Throwable)e);
            }
        }
    }

    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        Lock lock = this.obtainLock(profile);
        try {
            FirefoxBinary bin = binary == null ? new FirefoxBinary() : binary;
            return new NewProfileExtensionConnection(lock, bin, profile, host);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    protected Lock obtainLock(FirefoxProfile profile) {
        return new SocketLock();
    }

    protected void stopClient() {
        if (this.getCommandExecutor() instanceof LazyCommandExecutor) {
            ((LazyCommandExecutor)this.getCommandExecutor()).quit();
        }
    }

    private static Capabilities dropCapabilities(Capabilities capabilities) {
        DesiredCapabilities caps;
        if (capabilities == null) {
            return new DesiredCapabilities();
        }
        if (FirefoxDriver.isLegacy(capabilities)) {
            HashSet toRemove = Sets.newHashSet((Object[])new String[]{BINARY, PROFILE});
            caps = new DesiredCapabilities(Maps.filterKeys((Map)capabilities.asMap(), key -> !toRemove.contains(key)));
        } else {
            caps = new DesiredCapabilities(capabilities);
        }
        Proxy proxy = Proxy.extractFrom((Capabilities)capabilities);
        if (proxy != null) {
            caps.setCapability("proxy", new BeanToJsonConverter().convert((Object)proxy));
        }
        return caps;
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.execute("screenshot").getValue().toString();
        return (X)target.convertFromBase64Png(base64);
    }

    public static class LazyCommandExecutor
    implements CommandExecutor,
    NeedsLocalLogs {
        private ExtensionConnection connection;
        private final FirefoxBinary binary;
        private final FirefoxProfile profile;
        private LocalLogs logs = LocalLogs.getNullLogger();

        LazyCommandExecutor(FirefoxBinary binary, FirefoxProfile profile) {
            this.binary = binary;
            this.profile = profile;
        }

        public void setConnection(ExtensionConnection connection) {
            this.connection = connection;
            connection.setLocalLogs(this.logs);
        }

        public void quit() {
            if (this.connection != null) {
                this.connection.quit();
                this.connection = null;
            }
            if (this.profile != null) {
                this.profile.cleanTemporaryModel();
            }
        }

        public Response execute(Command command) throws IOException {
            if (this.connection == null) {
                if (command.getName().equals("quit")) {
                    return new Response();
                }
                throw new NoSuchSessionException("The FirefoxDriver cannot be used after quit() was called.");
            }
            return this.connection.execute(command);
        }

        public void setLocalLogs(LocalLogs logs) {
            this.logs = logs;
            if (this.connection != null) {
                this.connection.setLocalLogs(logs);
            }
        }

        public URI getAddressOfRemoteServer() {
            return this.connection.getAddressOfRemoteServer();
        }
    }

    public static final class SystemProperty {
        public static final String BROWSER_BINARY = "webdriver.firefox.bin";
        public static final String BROWSER_LOGFILE = "webdriver.firefox.logfile";
        public static final String BROWSER_LIBRARY_PATH = "webdriver.firefox.library.path";
        public static final String BROWSER_PROFILE = "webdriver.firefox.profile";
        public static final String DRIVER_XPI_PROPERTY = "webdriver.firefox.driver";
        public static final String DRIVER_USE_MARIONETTE = "webdriver.firefox.marionette";
    }
}

