/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;

public class FirefoxOptions {
    public static final String FIREFOX_OPTIONS = "moz:firefoxOptions";
    private String binaryPath;
    private FirefoxBinary actualBinary;
    private FirefoxProfile profile;
    private List<String> args = new ArrayList<String>();
    private Map<String, Boolean> booleanPrefs = new HashMap<String, Boolean>();
    private Map<String, Integer> intPrefs = new HashMap<String, Integer>();
    private Map<String, String> stringPrefs = new HashMap<String, String>();
    private Level logLevel = null;
    private Boolean legacy;
    private DesiredCapabilities desiredCapabilities = new DesiredCapabilities();
    private DesiredCapabilities requiredCapabilities = new DesiredCapabilities();

    static FirefoxOptions fromJsonMap(Map<String, Object> map) throws IOException {
        FirefoxOptions options = new FirefoxOptions();
        if (map.containsKey("binary")) {
            options.setBinary(FirefoxOptions.getOption(map, "binary", String.class));
        }
        if (map.containsKey("args")) {
            List list = FirefoxOptions.getOption(map, "args", List.class);
            options.addArguments(list);
        }
        if (map.containsKey("profile")) {
            Object value = map.get("profile");
            if (value instanceof String) {
                options.setProfile(FirefoxProfile.fromJson((String)value));
            } else if (value instanceof FirefoxProfile) {
                options.setProfile((FirefoxProfile)value);
            } else {
                throw new WebDriverException("In FirefoxOptions, don't know how to convert profile: " + map);
            }
        }
        if (map.containsKey("prefs")) {
            Map prefs = FirefoxOptions.getOption(map, "prefs", Map.class);
            prefs.entrySet().forEach(entry -> {
                Object value = entry.getValue();
                if (value instanceof Boolean) {
                    options.addPreference((String)entry.getKey(), (Boolean)value);
                } else if (value instanceof Integer) {
                    options.addPreference((String)entry.getKey(), (Integer)value);
                } else if (value instanceof String) {
                    options.addPreference((String)entry.getKey(), (String)value);
                } else {
                    throw new WebDriverException("Invalid Firefox preference value: " + (String)entry.getKey() + "=" + value);
                }
            });
        }
        return options;
    }

    private static <T> T getOption(Map<String, Object> map, String key, Class<T> type) {
        Object value = map.get(key);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new WebDriverException(String.format("In FirefoxOptions, expected key '%s' to be a %s: %s", key, type.getSimpleName(), map));
    }

    public FirefoxOptions setLegacy(boolean legacy) {
        this.legacy = legacy;
        return this;
    }

    public boolean isLegacy() {
        String forceMarionette = System.getProperty("webdriver.firefox.marionette");
        if (forceMarionette != null) {
            return Boolean.valueOf(forceMarionette) == false;
        }
        if (this.legacy != null) {
            return this.legacy;
        }
        return false;
    }

    public FirefoxOptions setBinary(FirefoxBinary binary) {
        this.actualBinary = (FirefoxBinary)Preconditions.checkNotNull((Object)binary);
        this.binaryPath = null;
        return this;
    }

    public FirefoxOptions setBinary(Path path) {
        StringBuilder builder = new StringBuilder(path.isAbsolute() ? "/" : "");
        this.binaryPath = Joiner.on((String)"/").appendTo(builder, (Iterable)path).toString();
        this.actualBinary = null;
        return this;
    }

    public FirefoxOptions setBinary(String path) {
        return this.setBinary(Paths.get((String)Preconditions.checkNotNull((Object)path), new String[0]));
    }

    public FirefoxBinary getBinary() {
        return this.getBinaryOrNull().orElse(new FirefoxBinary());
    }

    public Optional<FirefoxBinary> getBinaryOrNull() {
        if (this.actualBinary != null) {
            return Optional.of(this.actualBinary);
        }
        if (this.binaryPath != null) {
            return Optional.of(new FirefoxBinary(new File(this.binaryPath)));
        }
        if (this.desiredCapabilities.getCapability("firefox_binary") != null) {
            Object raw = this.desiredCapabilities.getCapability("firefox_binary");
            if (raw instanceof FirefoxBinary) {
                return Optional.of((FirefoxBinary)raw);
            }
            try {
                return Optional.of(new FirefoxBinary(new File(raw.toString())));
            }
            catch (WebDriverException wde) {
                throw new SessionNotCreatedException(wde.getMessage());
            }
        }
        if (this.desiredCapabilities.getCapability("version") != null) {
            try {
                FirefoxBinary.Channel channel = FirefoxBinary.Channel.fromString((String)this.desiredCapabilities.getCapability("version"));
                return Optional.of(new FirefoxBinary(channel));
            }
            catch (WebDriverException ex) {
                return Optional.of(new FirefoxBinary((String)this.desiredCapabilities.getCapability("version")));
            }
        }
        return Optional.empty();
    }

    public FirefoxOptions setProfile(FirefoxProfile profile) {
        this.profile = profile;
        return this;
    }

    public FirefoxProfile getProfile() {
        String suggestedProfile;
        FirefoxProfile profileToUse = this.profile;
        if (profileToUse == null) {
            profileToUse = this.extractProfile((Capabilities)this.desiredCapabilities);
        }
        if (profileToUse == null) {
            profileToUse = this.extractProfile((Capabilities)this.requiredCapabilities);
        }
        if (profileToUse == null && (suggestedProfile = System.getProperty("webdriver.firefox.profile")) != null && (profileToUse = new ProfilesIni().getProfile(suggestedProfile)) == null) {
            throw new WebDriverException(String.format("Firefox profile '%s' named in system property '%s' not found", suggestedProfile, "webdriver.firefox.profile"));
        }
        if (profileToUse == null) {
            profileToUse = new FirefoxProfile();
        }
        FirefoxOptions.populateProfile(profileToUse, (Capabilities)this.desiredCapabilities);
        FirefoxOptions.populateProfile(profileToUse, (Capabilities)this.requiredCapabilities);
        FirefoxProfile prefHolder = profileToUse;
        this.booleanPrefs.entrySet().forEach(pref -> prefHolder.setPreference((String)pref.getKey(), (Boolean)pref.getValue()));
        this.intPrefs.entrySet().forEach(pref -> prefHolder.setPreference((String)pref.getKey(), (Integer)pref.getValue()));
        this.stringPrefs.entrySet().forEach(pref -> prefHolder.setPreference((String)pref.getKey(), (String)pref.getValue()));
        return profileToUse;
    }

    private static void populateProfile(FirefoxProfile profile, Capabilities capabilities) {
        Preconditions.checkNotNull((Object)profile);
        if (capabilities == null) {
            return;
        }
        if (capabilities.getCapability("webStorageEnabled") != null) {
            Boolean supportsWebStorage = (Boolean)capabilities.getCapability("webStorageEnabled");
            profile.setPreference("dom.storage.enabled", supportsWebStorage);
        }
        if (capabilities.getCapability("acceptSslCerts") != null) {
            Boolean acceptCerts = (Boolean)capabilities.getCapability("acceptSslCerts");
            profile.setAcceptUntrustedCertificates(acceptCerts);
        }
        if (capabilities.getCapability("loggingPrefs") != null) {
            LoggingPreferences logsPrefs = (LoggingPreferences)capabilities.getCapability("loggingPrefs");
            for (String logtype : logsPrefs.getEnabledLogTypes()) {
                profile.setPreference("webdriver.log." + logtype, logsPrefs.getLevel(logtype).intValue());
            }
        }
    }

    FirefoxOptions setProfileSafely(FirefoxProfile profile) {
        if (profile == null) {
            return this;
        }
        return this.setProfile(profile);
    }

    public FirefoxOptions addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
        return this;
    }

    public FirefoxOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public FirefoxOptions addPreference(String key, boolean value) {
        this.booleanPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, int value) {
        this.intPrefs.put((String)Preconditions.checkNotNull((Object)key), value);
        return this;
    }

    public FirefoxOptions addPreference(String key, String value) {
        this.stringPrefs.put((String)Preconditions.checkNotNull((Object)key), (String)Preconditions.checkNotNull((Object)value));
        return this;
    }

    public FirefoxOptions setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public FirefoxOptions addDesiredCapabilities(Capabilities desiredCapabilities) {
        this.desiredCapabilities.merge(desiredCapabilities);
        FirefoxProfile suggestedProfile = this.extractProfile(desiredCapabilities);
        if (suggestedProfile != null) {
            if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
                throw new IllegalStateException("Unable to determine if preferences set on this option are the same as the profile in the capabilities");
            }
            if (this.profile != null && !suggestedProfile.equals(this.profile)) {
                throw new IllegalStateException("Profile has been set on both the capabilities and these options, but they're different. Unable to determine which one you want to use.");
            }
            this.profile = suggestedProfile;
        }
        return this;
    }

    public FirefoxOptions addRequiredCapabilities(Capabilities requiredCapabilities) {
        this.requiredCapabilities.merge(requiredCapabilities);
        FirefoxProfile suggestedProfile = this.extractProfile((Capabilities)this.desiredCapabilities);
        if (suggestedProfile != null) {
            if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
                throw new IllegalStateException("Unable to determine if preferences set on this option are the same as the profile in the capabilities");
            }
            if (this.profile != null && !suggestedProfile.equals(this.profile)) {
                throw new IllegalStateException("Profile has been set on both the capabilities and these options, but they're different. Unable to determine which one you want to use.");
            }
            this.profile = suggestedProfile;
        }
        return this;
    }

    private FirefoxProfile extractProfile(Capabilities capabilities) {
        if (capabilities == null) {
            return null;
        }
        Object raw = capabilities.getCapability("firefox_profile");
        if (raw == null) {
            return null;
        }
        if (raw instanceof FirefoxProfile) {
            return (FirefoxProfile)raw;
        }
        if (raw instanceof String) {
            try {
                return FirefoxProfile.fromJson((String)raw);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
        return null;
    }

    public Capabilities toDesiredCapabilities() {
        Object priorBinary;
        DesiredCapabilities capabilities = new DesiredCapabilities((Capabilities)this.desiredCapabilities);
        if (this.isLegacy()) {
            capabilities.setCapability("marionette", false);
        }
        if ((priorBinary = capabilities.getCapability("firefox_binary")) instanceof Path) {
            priorBinary = Joiner.on((String)"/").join((Iterable)((Path)priorBinary));
        }
        if (priorBinary instanceof String && (this.actualBinary != null || !priorBinary.equals(this.binaryPath))) {
            throw new IllegalStateException(String.format("Binary already set in capabilities, but is different from the one set here: %s, %s", priorBinary, this.binaryPath != null ? this.binaryPath : this.actualBinary));
        }
        if (priorBinary instanceof FirefoxBinary && (this.binaryPath != null || !priorBinary.equals(this.actualBinary))) {
            throw new IllegalStateException(String.format("Binary already set in capabilities, but is different from the one set here: %s, %s", priorBinary, this.actualBinary != null ? this.actualBinary : this.binaryPath));
        }
        Object priorProfile = capabilities.getCapability("firefox_profile");
        if (priorProfile != null) {
            if (!(this.booleanPrefs.isEmpty() && this.intPrefs.isEmpty() && this.stringPrefs.isEmpty())) {
                throw new IllegalStateException("Unable to determine if preferences set on this option are the same as the profile in the capabilities");
            }
            if (this.profile != null && !priorProfile.equals(this.profile)) {
                throw new IllegalStateException("Profile has been set on both the capabilities and these options, but they're different. Unable to determine which one you want to use.");
            }
        }
        capabilities.setCapability(FIREFOX_OPTIONS, (Object)this);
        if (this.actualBinary != null) {
            this.actualBinary.addCommandLineOptions(this.args.toArray(new String[this.args.size()]));
            capabilities.setCapability("firefox_binary", (Object)this.actualBinary);
        }
        if (this.binaryPath != null) {
            capabilities.setCapability("firefox_binary", this.binaryPath);
        }
        if (this.profile != null) {
            capabilities.setCapability("firefox_profile", (Object)this.profile);
        }
        return capabilities;
    }

    public Capabilities toRequiredCapabilities() {
        return this.requiredCapabilities;
    }

    public DesiredCapabilities addTo(DesiredCapabilities capabilities) {
        capabilities.merge(this.toDesiredCapabilities());
        return capabilities;
    }

    public JsonObject toJson() throws IOException {
        JsonObject options = new JsonObject();
        if (this.actualBinary != null) {
            options.addProperty("binary", this.actualBinary.getPath());
        } else if (this.binaryPath != null) {
            options.addProperty("binary", this.binaryPath);
        }
        if (this.profile != null) {
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, Comparable<Boolean>> entry : this.intPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (Integer)entry.getValue());
            }
            for (Map.Entry<String, Object> entry : this.stringPrefs.entrySet()) {
                this.profile.setPreference(entry.getKey(), (String)entry.getValue());
            }
            options.addProperty("profile", this.profile.toJson());
        } else {
            JsonObject allPrefs = new JsonObject();
            for (Map.Entry<String, Boolean> entry : this.booleanPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            for (Map.Entry<String, Integer> entry : this.intPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive((Number)entry.getValue()));
            }
            for (Map.Entry<String, String> entry : this.stringPrefs.entrySet()) {
                allPrefs.add(entry.getKey(), (JsonElement)new JsonPrimitive(entry.getValue()));
            }
            options.add("prefs", (JsonElement)allPrefs);
        }
        if (this.logLevel != null) {
            JsonObject level = new JsonObject();
            level.add("level", (JsonElement)new JsonPrimitive(this.logLevelToGeckoLevel()));
            options.add("log", (JsonElement)level);
        }
        JsonArray arguments = new JsonArray();
        for (String string : this.args) {
            arguments.add((JsonElement)new JsonPrimitive(string));
        }
        options.add("args", (JsonElement)arguments);
        return options;
    }

    private String logLevelToGeckoLevel() {
        if (this.logLevel.intValue() < Level.FINE.intValue()) {
            return "trace";
        }
        if (this.logLevel == Level.FINE) {
            return "debug";
        }
        if (this.logLevel == Level.CONFIG) {
            return "config";
        }
        if (this.logLevel == Level.INFO) {
            return "info";
        }
        if (this.logLevel == Level.WARNING) {
            return "warn";
        }
        if (this.logLevel == Level.SEVERE) {
            return "error";
        }
        if (this.logLevel == Level.OFF) {
            return "fatal";
        }
        return "debug";
    }

    public String toString() {
        return "{binary=" + this.getBinaryOrNull() + ", args=" + this.args + ", legacy=" + this.legacy + ", logLevel=" + this.logLevel + ", prefs=" + Stream.of(this.booleanPrefs, this.intPrefs, this.stringPrefs).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, e -> String.valueOf(e.getValue()))) + ", profile=" + this.profile + "}";
    }
}

