/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.internal.MarionetteConnection;
import org.openqa.selenium.interactions.ActionChainExecutor;
import org.openqa.selenium.interactions.CanPerformActionChain;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.RemoteActionChainExecutor;
import org.openqa.selenium.remote.RemoteExecuteMethod;
import org.openqa.selenium.remote.RemoteWebDriver;

@Beta
public class MarionetteDriver
extends FirefoxDriver
implements CanPerformActionChain {
    public MarionetteDriver() {
        this(new FirefoxBinary(), null);
    }

    public MarionetteDriver(FirefoxProfile profile) {
        super(profile);
    }

    public MarionetteDriver(Capabilities desiredCapabilities) {
        super(desiredCapabilities);
    }

    public MarionetteDriver(Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(desiredCapabilities, requiredCapabilities);
    }

    public MarionetteDriver(FirefoxBinary binary, FirefoxProfile profile) {
        super(binary, profile);
    }

    public MarionetteDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities capabilities) {
        super(binary, profile, capabilities);
    }

    public MarionetteDriver(FirefoxBinary binary, FirefoxProfile profile, Capabilities desiredCapabilities, Capabilities requiredCapabilities) {
        super(binary, profile, desiredCapabilities, requiredCapabilities);
    }

    @Override
    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        Lock lock = MarionetteDriver.obtainLock(profile);
        try {
            FirefoxBinary bin = binary == null ? new FirefoxBinary() : binary;
            return new MarionetteConnection(lock, bin, profile, host);
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public ActionChainExecutor getActionChainExecutor() {
        return new RemoteActionChainExecutor((ExecuteMethod)new RemoteExecuteMethod((RemoteWebDriver)this));
    }
}

