/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.Preferences;
import org.openqa.selenium.firefox.UnableToCreateProfileException;
import org.openqa.selenium.firefox.internal.ClasspathExtension;
import org.openqa.selenium.firefox.internal.Extension;
import org.openqa.selenium.firefox.internal.FileExtension;
import org.openqa.selenium.io.Cleanly;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.io.Zip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxProfile {
    public static final String PORT_PREFERENCE = "webdriver_firefox_port";
    private Preferences additionalPrefs = new Preferences();
    private Map<String, Extension> extensions = Maps.newHashMap();
    private boolean enableNativeEvents;
    private boolean loadNoFocusLib;
    private boolean acceptUntrustedCerts;
    private boolean untrustedCertIssuer;
    private File model;
    private static final String ENABLE_NATIVE_EVENTS_PREF = "webdriver_enable_native_events";
    private static final String ACCEPT_UNTRUSTED_CERTS_PREF = "webdriver_accept_untrusted_certs";
    private static final String ASSUME_UNTRUSTED_ISSUER_PREF = "webdriver_assume_untrusted_issuer";

    public FirefoxProfile() {
        this(null);
    }

    public FirefoxProfile(File profileDir) {
        this.model = profileDir;
        this.verifyModel(this.model);
        File prefsInModel = new File(this.model, "user.js");
        if (prefsInModel.exists()) {
            Map<String, String> existingPrefs = this.readExistingPrefs(prefsInModel);
            this.enableNativeEvents = Boolean.valueOf(existingPrefs.get(ENABLE_NATIVE_EVENTS_PREF));
            this.acceptUntrustedCerts = Boolean.valueOf(existingPrefs.get(ACCEPT_UNTRUSTED_CERTS_PREF));
            this.untrustedCertIssuer = Boolean.valueOf(existingPrefs.get(ASSUME_UNTRUSTED_ISSUER_PREF));
        } else {
            this.enableNativeEvents = FirefoxDriver.DEFAULT_ENABLE_NATIVE_EVENTS;
            this.acceptUntrustedCerts = true;
            this.untrustedCertIssuer = true;
        }
        this.loadNoFocusLib = false;
    }

    private void verifyModel(File model) {
        if (model == null) {
            return;
        }
        if (!model.exists()) {
            throw new UnableToCreateProfileException("Given model profile directory does not exist: " + model.getPath());
        }
        if (!model.isDirectory()) {
            throw new UnableToCreateProfileException("Given model profile directory is not a directory: " + model.getAbsolutePath());
        }
    }

    protected void addWebDriverExtensionIfNeeded() {
        if (this.extensions.containsKey("webdriver")) {
            return;
        }
        ClasspathExtension extension = new ClasspathExtension(FirefoxProfile.class, "/webdriver.xpi");
        this.addExtension("webdriver", extension);
    }

    public void addExtension(Class<?> loadResourcesUsing, String loadFrom) throws IOException {
        File file = new File(loadFrom);
        if (file.exists()) {
            this.addExtension(file);
            return;
        }
        this.addExtension(loadFrom, new ClasspathExtension(loadResourcesUsing, loadFrom));
    }

    public void addExtension(File extensionToInstall) throws IOException {
        this.addExtension(extensionToInstall.getName(), new FileExtension(extensionToInstall));
    }

    protected void addExtension(String key, Extension extension) {
        String name = this.deriveExtensionName(key);
        this.extensions.put(name, extension);
    }

    private String deriveExtensionName(String originalName) {
        String[] pieces = originalName.replace('\\', '/').split("/");
        String name = pieces[pieces.length - 1];
        name = name.replaceAll("\\..*?$", "");
        return name;
    }

    private Map<String, String> readExistingPrefs(File userPrefs) {
        HashMap<String, String> prefs = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(userPrefs));
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("user_pref(\"")) {
                    line = reader.readLine();
                    continue;
                }
                line = line.substring("user_pref(\"".length());
                line = line.substring(0, line.length() - ");".length());
                String[] parts = line.split(",");
                parts[0] = parts[0].substring(0, parts[0].length() - 1);
                prefs.put(parts[0].trim(), parts[1].trim());
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                Cleanly.close(reader);
                throw throwable;
            }
        }
        Cleanly.close((Reader)reader);
        return prefs;
    }

    public void setPreference(String key, String value) {
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, boolean value) {
        this.additionalPrefs.setPreference(key, value);
    }

    public void setPreference(String key, int value) {
        this.additionalPrefs.setPreference(key, value);
    }

    public FirefoxProfile setProxyPreferences(Proxy proxy) {
        if (proxy.getProxyType() == Proxy.ProxyType.UNSPECIFIED) {
            return this;
        }
        this.setPreference("network.proxy.type", proxy.getProxyType().ordinal());
        switch (proxy.getProxyType()) {
            case MANUAL: {
                this.setPreference("network.proxy.no_proxies_on", "");
                this.setManualProxyPreference("ftp", proxy.getFtpProxy());
                this.setManualProxyPreference("http", proxy.getHttpProxy());
                this.setManualProxyPreference("ssl", proxy.getSslProxy());
                if (proxy.getNoProxy() == null) break;
                this.setPreference("network.proxy.no_proxies_on", proxy.getNoProxy());
                break;
            }
            case PAC: {
                this.setPreference("network.proxy.autoconfig_url", proxy.getProxyAutoconfigUrl());
            }
        }
        return this;
    }

    private void setManualProxyPreference(String key, String settingString) {
        if (settingString == null) {
            return;
        }
        String[] hostPort = settingString.split(":");
        this.setPreference("network.proxy." + key, hostPort[0]);
        if (hostPort.length > 1) {
            this.setPreference("network.proxy." + key + "_port", Integer.parseInt(hostPort[1]));
        }
    }

    protected Preferences getAdditionalPreferences() {
        return this.additionalPrefs;
    }

    public void updateUserPrefs(File userPrefs) {
        Map<String, String> prefs = new HashMap<String, String>();
        prefs.put("browser.startup.homepage", "\"about:blank\"");
        prefs.put("browser.startup.page", "0");
        if (userPrefs.exists()) {
            prefs = this.readExistingPrefs(userPrefs);
            if (!userPrefs.delete()) {
                throw new WebDriverException("Cannot delete existing user preferences");
            }
        }
        this.additionalPrefs.addTo(prefs);
        prefs.put("app.update.auto", "false");
        prefs.put("app.update.enabled", "false");
        prefs.put("browser.download.manager.showWhenStarting", "false");
        prefs.put("browser.EULA.override", "true");
        prefs.put("browser.EULA.3.accepted", "true");
        prefs.put("browser.link.open_external", "2");
        prefs.put("browser.link.open_newwindow", "2");
        prefs.put("browser.offline", "false");
        prefs.put("browser.safebrowsing.enabled", "false");
        prefs.put("browser.search.update", "false");
        prefs.put("browser.sessionstore.resume_from_crash", "false");
        prefs.put("browser.shell.checkDefaultBrowser", "false");
        prefs.put("browser.tabs.warnOnClose", "false");
        prefs.put("browser.tabs.warnOnOpen", "false");
        prefs.put("devtools.errorconsole.enabled", "true");
        prefs.put("dom.disable_open_during_load", "false");
        prefs.put("dom.max_script_run_time", "30");
        prefs.put("extensions.logging.enabled", "true");
        prefs.put("extensions.update.enabled", "false");
        prefs.put("extensions.update.notifyUser", "false");
        prefs.put("network.manage-offline-status", "false");
        prefs.put("network.http.max-connections-per-server", "10");
        prefs.put("security.fileuri.origin_policy", "3");
        prefs.put("security.fileuri.strict_origin_policy", "false");
        prefs.put("security.warn_entering_secure", "false");
        prefs.put("security.warn_submit_insecure", "false");
        prefs.put("security.warn_entering_secure.show_once", "false");
        prefs.put("security.warn_entering_weak", "false");
        prefs.put("security.warn_entering_weak.show_once", "false");
        prefs.put("security.warn_leaving_secure", "false");
        prefs.put("security.warn_leaving_secure.show_once", "false");
        prefs.put("security.warn_submit_insecure", "false");
        prefs.put("security.warn_viewing_mixed", "false");
        prefs.put("security.warn_viewing_mixed.show_once", "false");
        prefs.put("signon.rememberSignons", "false");
        prefs.put("toolkit.networkmanager.disable", "true");
        prefs.put(ENABLE_NATIVE_EVENTS_PREF, Boolean.toString(this.enableNativeEvents));
        prefs.put(ACCEPT_UNTRUSTED_CERTS_PREF, Boolean.toString(this.acceptUntrustedCerts));
        prefs.put(ASSUME_UNTRUSTED_ISSUER_PREF, Boolean.toString(this.untrustedCertIssuer));
        prefs.put("javascript.options.showInConsole", "true");
        prefs.put("browser.dom.window.dump.enabled", "true");
        prefs.put("dom.report_all_js_exceptions", "true");
        prefs.put("startup.homepage_welcome_url", prefs.get("browser.startup.homepage"));
        if (!"about:blank".equals(prefs.get("browser.startup.homepage"))) {
            prefs.put("browser.startup.page", "1");
        }
        this.writeNewPrefs(userPrefs, prefs);
    }

    protected void deleteLockFiles(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, ".parentlock");
        File windowsLockFile = new File(profileDir, "parent.lock");
        macAndLinuxLockFile.delete();
        windowsLockFile.delete();
    }

    public void deleteExtensionsCacheIfItExists(File profileDir) {
        File cacheFile = new File(profileDir, "extensions.cache");
        if (cacheFile.exists()) {
            cacheFile.delete();
        }
    }

    protected void writeNewPrefs(File userPrefs, Map<String, String> prefs) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(userPrefs);
            for (Map.Entry<String, String> entry : prefs.entrySet()) {
                ((Writer)writer).append(String.format("user_pref(\"%s\", %s);\n", entry.getKey(), entry.getValue()));
            }
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                Cleanly.close(writer);
                throw throwable;
            }
        }
        Cleanly.close((Writer)writer);
    }

    public boolean enableNativeEvents() {
        return this.enableNativeEvents;
    }

    public void setEnableNativeEvents(boolean enableNativeEvents) {
        this.enableNativeEvents = enableNativeEvents;
    }

    public boolean alwaysLoadNoFocusLib() {
        return this.loadNoFocusLib;
    }

    public void setAlwaysLoadNoFocusLib(boolean loadNoFocusLib) {
        this.loadNoFocusLib = loadNoFocusLib;
    }

    public void setAcceptUntrustedCertificates(boolean acceptUntrustedSsl) {
        this.acceptUntrustedCerts = acceptUntrustedSsl;
    }

    public void setAssumeUntrustedCertificateIssuer(boolean untrustedIssuer) {
        this.untrustedCertIssuer = untrustedIssuer;
    }

    public boolean isRunning(File profileDir) {
        File macAndLinuxLockFile = new File(profileDir, ".parentlock");
        File windowsLockFile = new File(profileDir, "parent.lock");
        return macAndLinuxLockFile.exists() || windowsLockFile.exists();
    }

    public void clean(File profileDir) {
        TemporaryFilesystem.getDefaultTmpFS().deleteTempDir(profileDir);
    }

    public String toJson() throws IOException {
        File generatedProfile = this.layoutOnDisk();
        return new Zip().zip(generatedProfile);
    }

    public static FirefoxProfile fromJson(String json) throws IOException {
        File dir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("webdriver", "duplicated");
        new Zip().unzip(json, dir);
        return new FirefoxProfile(dir);
    }

    public File layoutOnDisk() {
        try {
            File profileDir = TemporaryFilesystem.getDefaultTmpFS().createTempDir("anonymous", "webdriver-profile");
            File userPrefs = new File(profileDir, "user.js");
            this.copyModel(this.model, profileDir);
            this.installExtensions(profileDir);
            this.deleteLockFiles(profileDir);
            this.deleteExtensionsCacheIfItExists(profileDir);
            this.updateUserPrefs(userPrefs);
            return profileDir;
        }
        catch (IOException e) {
            throw new UnableToCreateProfileException(e);
        }
    }

    protected void copyModel(File sourceDir, File profileDir) throws IOException {
        if (sourceDir == null || !sourceDir.exists()) {
            return;
        }
        FileUtils.copyDirectory((File)sourceDir, (File)profileDir);
    }

    protected void installExtensions(File parentDir) throws IOException {
        File extensionsDir = new File(parentDir, "extensions");
        for (Extension extension : this.extensions.values()) {
            extension.writeTo(extensionsDir);
        }
    }
}

