/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.IllegalLocatorException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Platform;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.Speed;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.Command;
import org.openqa.selenium.firefox.Context;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.FirefoxWebElement;
import org.openqa.selenium.firefox.Response;
import org.openqa.selenium.firefox.internal.ExtensionConnectionFactory;
import org.openqa.selenium.firefox.internal.ProfilesIni;
import org.openqa.selenium.internal.FileHandler;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.ReturnedCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirefoxDriver
implements WebDriver,
JavascriptExecutor,
TakesScreenshot,
FindsById,
FindsByClassName,
FindsByCssSelector,
FindsByLinkText,
FindsByName,
FindsByTagName,
FindsByXPath {
    public static final int DEFAULT_PORT = 7055;
    public static final boolean DEFAULT_ENABLE_NATIVE_EVENTS = Platform.getCurrent().is(Platform.WINDOWS);
    public static final boolean ACCEPT_UNTRUSTED_CERTIFICATES = true;
    public static final boolean ASSUME_UNTRUSTED_ISSUER = true;
    private final Set<String> alertWhiteListedCommands = new HashSet<String>(){
        {
            this.add("dismissAlert");
        }
    };
    private final ExtensionConnection extension;
    protected Context context;
    private FirefoxAlert currentAlert;

    public FirefoxDriver() {
        this(new FirefoxBinary(), null);
    }

    public FirefoxDriver(FirefoxProfile profile) {
        this(new FirefoxBinary(), profile);
    }

    public FirefoxDriver(FirefoxBinary binary, FirefoxProfile profile) {
        FirefoxProfile profileToUse = profile;
        String suggestedProfile = System.getProperty("webdriver.firefox.profile");
        if (profileToUse == null && suggestedProfile != null) {
            profileToUse = new ProfilesIni().getProfile(suggestedProfile);
        } else if (profileToUse == null) {
            profileToUse = new FirefoxProfile();
            profileToUse.addWebDriverExtensionIfNeeded(false);
        } else {
            profileToUse.addWebDriverExtensionIfNeeded(false);
        }
        this.prepareEnvironment();
        this.extension = this.connectTo(binary, profileToUse, "localhost");
        this.fixId();
    }

    private FirefoxDriver(ExtensionConnection extension, Context context) {
        this.extension = extension;
        this.context = context;
    }

    protected ExtensionConnection connectTo(FirefoxBinary binary, FirefoxProfile profile, String host) {
        return ExtensionConnectionFactory.connectTo(binary, profile, host);
    }

    protected void prepareEnvironment() {
    }

    public void close() {
        try {
            this.sendMessage(WebDriverException.class, "close", new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPageSource() {
        return this.sendMessage(WebDriverException.class, "getPageSource", new Object[0]);
    }

    public void get(String url) {
        this.sendMessage(WebDriverException.class, "get", url);
    }

    public String getCurrentUrl() {
        return this.sendMessage(WebDriverException.class, "getCurrentUrl", new Object[0]);
    }

    public String getTitle() {
        return this.sendMessage(WebDriverException.class, "title", new Object[0]);
    }

    public List<WebElement> findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    public WebElement findElement(By by) {
        return by.findElement((SearchContext)this);
    }

    public WebElement findElementById(String using) {
        return this.findElement("id", using);
    }

    public List<WebElement> findElementsById(String using) {
        return this.findElements("id", using);
    }

    public WebElement findElementByLinkText(String using) {
        return this.findElement("link text", using);
    }

    public List<WebElement> findElementsByLinkText(String using) {
        return this.findElements("link text", using);
    }

    public WebElement findElementByPartialLinkText(String using) {
        return this.findElement("partial link text", using);
    }

    public List<WebElement> findElementsByPartialLinkText(String using) {
        return this.findElements("partial link text", using);
    }

    public List<WebElement> findElementsByXPath(String using) {
        return this.findElements("xpath", using);
    }

    public WebElement findElementByXPath(String using) {
        return this.findElement("xpath", using);
    }

    public List<WebElement> findElementsByClassName(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (using.matches(".*\\s+.*")) {
            throw new IllegalLocatorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        return this.findElements("class name", using);
    }

    public WebElement findElementByClassName(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the class name expression is null.");
        }
        if (using.matches(".*\\s+.*")) {
            throw new IllegalLocatorException("Compound class names are not supported. Consider searching for one class name and filtering the results.");
        }
        return this.findElement("class name", using);
    }

    public WebElement findElementByCssSelector(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the css selector is null.");
        }
        return this.findElement("css selector", using);
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        if (using == null) {
            throw new IllegalArgumentException("Cannot find elements when the css selector is null.");
        }
        return this.findElements("css selector", using);
    }

    public WebElement findElementByName(String using) {
        return this.findElement("name", using);
    }

    public List<WebElement> findElementsByName(String using) {
        return this.findElements("name", using);
    }

    public WebElement findElementByTagName(String using) {
        return this.findElement("tag name", using);
    }

    public List<WebElement> findElementsByTagName(String using) {
        return this.findElements("tag name", using);
    }

    private WebElement findElement(String method, String selector) {
        String elementId = this.sendMessage(NoSuchElementException.class, "findElement", method, selector);
        return new FirefoxWebElement(this, elementId);
    }

    private List<WebElement> findElements(String method, String selector) {
        JSONArray returnedIds = (JSONArray)this.executeCommand(WebDriverException.class, "findElements", method, selector);
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        try {
            for (int i = 0; i < returnedIds.length(); ++i) {
                String id = returnedIds.getString(i);
                elements.add((WebElement)new FirefoxWebElement(this, id));
            }
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
        return elements;
    }

    public WebDriver.TargetLocator switchTo() {
        return new FirefoxTargetLocator();
    }

    public WebDriver.Navigation navigate() {
        return new FirefoxNavigation();
    }

    protected WebDriver findActiveDriver() {
        String response = this.sendMessage(WebDriverException.class, "newSession", new Object[0]);
        Context newContext = new Context(response);
        if (newContext.getDriverId().equals(newContext.getDriverId())) {
            return this;
        }
        return new FirefoxDriver(this.extension, newContext);
    }

    private String sendMessage(Class<? extends WebDriverException> throwOnFailure, String methodName, Object ... parameters) {
        return this.sendMessage(throwOnFailure, new Command(this.context, methodName, parameters));
    }

    protected String sendMessage(Class<? extends RuntimeException> throwOnFailure, Command command) {
        return String.valueOf(this.executeCommand(throwOnFailure, command));
    }

    protected Object executeCommand(Class<? extends RuntimeException> throwOnFailure, String methodName, Object ... parameters) {
        return this.executeCommand(throwOnFailure, new Command(this.context, methodName, parameters));
    }

    protected Object executeCommand(Class<? extends RuntimeException> throwOnFailure, Command command) {
        JSONObject jsonObject;
        if (this.currentAlert != null && !this.alertWhiteListedCommands.contains(command.getCommandName())) {
            ((FirefoxTargetLocator)this.switchTo()).alert().dismiss();
            throw new UnhandledAlertException(command.getCommandName());
        }
        Response response = this.extension.sendMessageAndWaitForResponse(throwOnFailure, command);
        this.context = response.getContext();
        response.ifNecessaryThrow(throwOnFailure);
        Object rawResponse = response.getExtraResult("response");
        if (rawResponse instanceof JSONObject && (jsonObject = (JSONObject)rawResponse).has("__webdriverType")) {
            try {
                this.currentAlert = new FirefoxAlert(jsonObject.getString("text"));
                return null;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return rawResponse;
    }

    private void fixId() {
        String response = this.sendMessage(WebDriverException.class, "newSession", new Object[0]);
        this.context = new Context(response);
    }

    public void quit() {
        this.extension.quit();
    }

    public String getWindowHandle() {
        return this.sendMessage(WebDriverException.class, "getCurrentWindowHandle", new Object[0]);
    }

    public Set<String> getWindowHandles() {
        JSONArray allHandles = (JSONArray)this.executeCommand(WebDriverException.class, "getWindowHandles", new Object[0]);
        HashSet<String> toReturn = new HashSet<String>();
        for (int i = 0; i < allHandles.length(); ++i) {
            String handle = allHandles.optString(i, null);
            if (handle == null) continue;
            toReturn.add(handle);
        }
        return toReturn;
    }

    public Object executeScript(String script, Object ... args) {
        script = script.replaceAll("\"", "\\\"");
        Object[] convertedArgs = this.convertToJsObjects(args);
        try {
            JSONObject jsonResponse = (JSONObject)this.executeCommand(WebDriverException.class, "executeScript", script, convertedArgs);
            return this.parseJavascriptObjectFromResponse(jsonResponse.getString("type"), jsonResponse.get("value"));
        }
        catch (JSONException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public Object parseJavascriptObjectFromResponse(String resultType, Object response) {
        if ("NULL".equals(resultType)) {
            return null;
        }
        if ("ARRAY".equals(resultType)) {
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                JSONArray array = (JSONArray)response;
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject subObject = (JSONObject)array.get(i);
                    list.add(this.parseJavascriptObjectFromResponse(subObject.getString("type"), subObject.get("value")));
                }
            }
            catch (JSONException e) {
                throw new WebDriverException((Throwable)e);
            }
            return list;
        }
        if ("ELEMENT".equals(resultType)) {
            return new FirefoxWebElement(this, (String)response);
        }
        if (response instanceof Integer) {
            return new Long(((Integer)response).intValue());
        }
        return response;
    }

    public boolean isJavascriptEnabled() {
        return true;
    }

    private Object[] convertToJsObjects(Object[] args) {
        if (args.length == 0) {
            return null;
        }
        Object[] converted = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            converted[i] = this.convertToJsObject(args[i]);
        }
        return converted;
    }

    private Object convertToJsObject(Object arg) {
        HashMap<String, Object> converted = new HashMap<String, Object>();
        if (arg instanceof String) {
            converted.put("type", "STRING");
            converted.put("value", arg);
        } else if (arg instanceof Double || arg instanceof Float) {
            converted.put("type", "NUMBER");
            converted.put("value", ((Number)arg).doubleValue());
        } else if (arg instanceof Number) {
            converted.put("type", "NUMBER");
            converted.put("value", ((Number)arg).longValue());
        } else if (this.isPrimitiveNumberType(arg)) {
            converted.put("type", "NUMBER");
            converted.put("value", this.getPrimitiveTypeAsLong(arg));
        } else if (arg instanceof Boolean) {
            converted.put("type", "BOOLEAN");
            converted.put("value", (Boolean)arg);
        } else if (arg.getClass() == Boolean.TYPE) {
            converted.put("type", "BOOLEAN");
            converted.put("value", arg);
        } else if (arg instanceof FirefoxWebElement) {
            converted.put("type", "ELEMENT");
            converted.put("value", ((FirefoxWebElement)arg).getElementId());
        } else {
            if (arg instanceof Collection) {
                Collection args = (Collection)arg;
                Object[] list = new Object[args.size()];
                int i = 0;
                for (Object o : args) {
                    list[i] = this.convertToJsObject(o);
                    ++i;
                }
                return list;
            }
            throw new IllegalArgumentException("Argument is of an illegal type: " + arg);
        }
        return converted;
    }

    private Long getPrimitiveTypeAsLong(Object arg) {
        return Long.valueOf(String.valueOf(arg));
    }

    private boolean isPrimitiveNumberType(Object arg) {
        if (!arg.getClass().isPrimitive()) {
            return false;
        }
        return arg.getClass() == Long.TYPE || arg.getClass() == Integer.TYPE || arg.getClass() == Short.TYPE;
    }

    public WebDriver.Options manage() {
        return new FirefoxOptions();
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = this.sendMessage(WebDriverException.class, "getScreenshotAsBase64", new Object[0]);
        return (X)target.convertFromBase64Png(base64);
    }

    @Deprecated
    public void saveScreenshot(File pngFile) {
        if (pngFile == null) {
            throw new IllegalArgumentException("Method parameter pngFile must not be null");
        }
        File tmpfile = (File)this.getScreenshotAs(OutputType.FILE);
        File dir = pngFile.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new WebDriverException("Could not create directory " + dir.getAbsolutePath());
        }
        try {
            FileHandler.copy((File)tmpfile, (File)pngFile);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private class FirefoxAlert
    implements Alert {
        private String text;

        public FirefoxAlert(String text) {
            this.text = text;
        }

        public void dismiss() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "dismissAlert", new Object[]{this.text});
            FirefoxDriver.this.currentAlert = null;
        }

        public void accept() {
        }

        public String getText() {
            return this.text;
        }
    }

    private class FirefoxNavigation
    implements WebDriver.Navigation {
        private FirefoxNavigation() {
        }

        public void back() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "goBack", new Object[0]);
        }

        public void forward() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "goForward", new Object[0]);
        }

        public void to(String url) {
            FirefoxDriver.this.get(url);
        }

        public void to(URL url) {
            FirefoxDriver.this.get(String.valueOf(url));
        }

        public void refresh() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "refresh", new Object[0]);
        }
    }

    private class FirefoxTargetLocator
    implements WebDriver.TargetLocator {
        private FirefoxTargetLocator() {
        }

        public WebDriver frame(int frameIndex) {
            FirefoxDriver.this.sendMessage(NoSuchFrameException.class, "switchToFrame", new Object[]{frameIndex});
            return FirefoxDriver.this;
        }

        public WebDriver frame(String frameName) {
            FirefoxDriver.this.sendMessage(NoSuchFrameException.class, "switchToFrame", new Object[]{frameName});
            return FirefoxDriver.this;
        }

        public WebDriver window(String windowName) {
            String response = FirefoxDriver.this.sendMessage(NoSuchWindowException.class, "switchToWindow", new Object[]{String.valueOf(windowName)});
            if (response == null || "No window found".equals(response)) {
                throw new NoSuchWindowException("Cannot find window: " + windowName);
            }
            try {
                FirefoxDriver.this.context = new Context(response);
            }
            catch (NumberFormatException e) {
                throw new WebDriverException("When switching to window: " + windowName + " ---- " + response);
            }
            return FirefoxDriver.this;
        }

        public WebDriver defaultContent() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "switchToDefaultContent", new Object[0]);
            return FirefoxDriver.this;
        }

        public WebElement activeElement() {
            String elementId = FirefoxDriver.this.sendMessage(NoSuchElementException.class, "switchToActiveElement", new Object[0]);
            return new FirefoxWebElement(FirefoxDriver.this, elementId);
        }

        public Alert alert() {
            if (FirefoxDriver.this.currentAlert != null) {
                return FirefoxDriver.this.currentAlert;
            }
            throw new NoAlertPresentException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FirefoxOptions
    implements WebDriver.Options {
        private final List<String> fieldNames = Arrays.asList("domain", "expiry", "name", "path", "value", "secure");
        private final DateFormat RFC_1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss 'GMT'Z", Locale.US);
        private final int SLOW_SPEED = 1;
        private final int MEDIUM_SPEED = 10;
        private final int FAST_SPEED = 100;

        private FirefoxOptions() {
        }

        public void addCookie(Cookie cookie) {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "addCookie", new Object[]{this.convertToJson(cookie)});
        }

        private String convertToJson(Cookie cookie) {
            PropertyDescriptor[] properties;
            BeanInfo info;
            JSONObject json = new JSONObject();
            try {
                info = Introspector.getBeanInfo(Cookie.class);
            }
            catch (IntrospectionException e) {
                throw new WebDriverException((Throwable)e);
            }
            for (PropertyDescriptor property : properties = info.getPropertyDescriptors()) {
                if (!this.fieldNames.contains(property.getName())) continue;
                try {
                    Object result = property.getReadMethod().invoke((Object)cookie, new Object[0]);
                    json.put(property.getName(), result);
                }
                catch (Exception e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            if (cookie.getExpiry() != null) {
                try {
                    json.put("expiry", (Object)this.RFC_1123_DATE_FORMAT.format(cookie.getExpiry()));
                }
                catch (JSONException e) {
                    throw new WebDriverException((Throwable)e);
                }
            }
            return json.toString();
        }

        public Cookie getCookieNamed(String name) {
            Set<Cookie> allCookies = this.getCookies();
            for (Cookie cookie : allCookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
            return null;
        }

        public Set<Cookie> getCookies() {
            JSONArray response = (JSONArray)FirefoxDriver.this.executeCommand(WebDriverException.class, "getCookie", new Object[0]);
            HashSet<Cookie> cookies = new HashSet<Cookie>();
            try {
                for (int i = 0; i < response.length(); ++i) {
                    String cookieString = response.getString(i).trim();
                    if ("".equals(cookieString)) continue;
                    HashMap<String, String> attributesMap = new HashMap<String, String>();
                    attributesMap.put("name", "");
                    attributesMap.put("value", "");
                    attributesMap.put("domain", "");
                    attributesMap.put("path", "");
                    attributesMap.put("expires", "");
                    attributesMap.put("secure", "false");
                    for (String attribute : cookieString.split(";")) {
                        if (attribute.contains("=")) {
                            String[] tokens = attribute.trim().split("=", 2);
                            if (((String)attributesMap.get("name")).equals("")) {
                                attributesMap.put("name", tokens[0]);
                                attributesMap.put("value", tokens[1]);
                                continue;
                            }
                            if ("domain".equals(tokens[0]) && tokens[1].trim().startsWith(".")) {
                                int offset = tokens[1].indexOf(".") + 1;
                                attributesMap.put("domain", tokens[1].substring(offset));
                                continue;
                            }
                            if (tokens.length <= 1) continue;
                            attributesMap.put(tokens[0], tokens[1]);
                            continue;
                        }
                        if (!attribute.equals("secure")) continue;
                        attributesMap.put("secure", "true");
                    }
                    Date expires = null;
                    String expiry = (String)attributesMap.get("expires");
                    if (expiry != null && !"".equals(expiry) && !expiry.equals("0")) {
                        expires = new Date(Long.parseLong((String)attributesMap.get("expires")) * 1000L);
                    }
                    cookies.add((Cookie)new ReturnedCookie((String)attributesMap.get("name"), (String)attributesMap.get("value"), (String)attributesMap.get("domain"), (String)attributesMap.get("path"), expires, Boolean.parseBoolean((String)attributesMap.get("secure")), FirefoxDriver.this.getCurrentUrl()));
                }
            }
            catch (JSONException e) {
                throw new WebDriverException((Throwable)e);
            }
            return cookies;
        }

        public void deleteCookieNamed(String name) {
            Cookie toDelete = new Cookie(name, "");
            FirefoxDriver.this.sendMessage(WebDriverException.class, "deleteCookie", new Object[]{this.convertToJson(toDelete)});
        }

        public void deleteCookie(Cookie cookie) {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "deleteCookie", new Object[]{this.convertToJson(cookie)});
        }

        public void deleteAllCookies() {
            FirefoxDriver.this.sendMessage(WebDriverException.class, "deleteAllCookies", new Object[0]);
        }

        public Speed getSpeed() {
            Speed speed;
            int pixelSpeed = (Integer)FirefoxDriver.this.executeCommand(WebDriverException.class, "getMouseSpeed", new Object[0]);
            switch (pixelSpeed) {
                case 1: {
                    speed = Speed.SLOW;
                    break;
                }
                case 10: {
                    speed = Speed.MEDIUM;
                    break;
                }
                case 100: {
                    speed = Speed.FAST;
                    break;
                }
                default: {
                    speed = Speed.FAST;
                }
            }
            return speed;
        }

        public void setSpeed(Speed speed) {
            int pixelSpeed;
            switch (speed) {
                case SLOW: {
                    pixelSpeed = 1;
                    break;
                }
                case MEDIUM: {
                    pixelSpeed = 10;
                    break;
                }
                case FAST: {
                    pixelSpeed = 100;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            FirefoxDriver.this.sendMessage(WebDriverException.class, "setMouseSpeed", new Object[]{pixelSpeed});
        }
    }
}

