/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CircularOutputStream
extends OutputStream {
    private static final int DEFAULT_SIZE = 4096;
    private int start;
    private int end;
    private boolean filled = false;
    private byte[] buffer;
    private FileOutputStream out_log;

    public CircularOutputStream(int maxSize) {
        this.buffer = new byte[maxSize];
        String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
        if (firefoxLogFile != null) {
            try {
                this.out_log = new FileOutputStream(new File(firefoxLogFile));
            }
            catch (FileNotFoundException e) {
                this.out_log = null;
            }
        }
    }

    public CircularOutputStream() {
        this(4096);
    }

    public void write(int b) throws IOException {
        if (this.end == this.buffer.length) {
            this.filled = true;
            this.end = 0;
        }
        if (this.filled && this.end == this.start) {
            this.start = this.start == this.buffer.length - 1 ? 0 : this.start + 1;
        }
        this.buffer[this.end++] = (byte)b;
        if (this.out_log != null) {
            this.out_log.write(b);
        }
    }

    public String toString() {
        int size = this.filled ? this.buffer.length : this.end;
        byte[] toReturn = new byte[size];
        if (!this.filled) {
            System.arraycopy(this.buffer, 0, toReturn, 0, this.end);
            return new String(toReturn);
        }
        System.arraycopy(this.buffer, this.start, toReturn, 0, this.buffer.length - this.start);
        System.arraycopy(this.buffer, 0, toReturn, this.buffer.length - this.start, this.end);
        return new String(toReturn);
    }
}

