/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge.edgehtml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.edge.EdgeDriverService;

public class EdgeHtmlDriverService
extends EdgeDriverService {
    public EdgeHtmlDriverService(File executable, int port, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, DEFAULT_TIMEOUT, args, environment);
    }

    public EdgeHtmlDriverService(File executable, int port, Duration timeout, List<String> args, Map<String, String> environment) throws IOException {
        super(executable, port, timeout, args, environment);
    }

    public static EdgeHtmlDriverService createDefaultService() {
        return (EdgeHtmlDriverService)new Builder().build();
    }

    public static class Builder
    extends EdgeDriverService.Builder<EdgeHtmlDriverService, Builder> {
        private boolean verbose = Boolean.getBoolean("webdriver.edge.verboseLogging");

        public boolean isLegacy() {
            return true;
        }

        public int score(Capabilities capabilities) {
            int score = 0;
            if ("MicrosoftEdge".equals(capabilities.getBrowserName())) {
                ++score;
            }
            return score;
        }

        public EdgeDriverService.Builder withVerbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        protected File findDefaultExecutable() {
            return EdgeHtmlDriverService.findExecutable((String)"MicrosoftWebDriver", (String)"webdriver.edge.driver", (String)"https://github.com/SeleniumHQ/selenium/wiki/MicrosoftWebDriver", (String)"http://go.microsoft.com/fwlink/?LinkId=619687");
        }

        protected ImmutableList<String> createArgs() {
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.verbose) {
                argsBuilder.add((Object)"--verbose");
            }
            return argsBuilder.build();
        }

        protected EdgeHtmlDriverService createDriverService(File exe, int port, Duration timeout, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                EdgeHtmlDriverService service = new EdgeHtmlDriverService(exe, port, timeout, (List<String>)args, (Map<String, String>)environment);
                if (this.getLogFile() != null) {
                    service.sendOutputTo(new FileOutputStream(this.getLogFile()));
                } else {
                    String logFile = System.getProperty("webdriver.edge.logfile");
                    if (logFile != null) {
                        service.sendOutputTo(new FileOutputStream(logFile));
                    }
                }
                return service;
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

