/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chromium.ChromiumDriver;
import org.openqa.selenium.chromium.ChromiumDriverCommandExecutor;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class EdgeDriver
extends ChromiumDriver {
    public static final String DRIVER_USE_EDGE_EDGEHTML = "webdriver.edge.edgehtml";

    public EdgeDriver() {
        this(new EdgeOptions());
    }

    public EdgeDriver(EdgeOptions options) {
        super(EdgeDriver.toExecutor(options), (Capabilities)options, "ms:edgeOptions");
    }

    @Deprecated
    public EdgeDriver(Capabilities capabilities) {
        super(EdgeDriver.toExecutor(new EdgeOptions()), capabilities, "ms:edgeOptions");
    }

    private static CommandExecutor toExecutor(EdgeOptions options) {
        Objects.requireNonNull(options, "No options to construct executor from");
        boolean isLegacy = System.getProperty(DRIVER_USE_EDGE_EDGEHTML) == null || Boolean.getBoolean(DRIVER_USE_EDGE_EDGEHTML);
        EdgeDriverService.Builder builder = StreamSupport.stream(ServiceLoader.load(DriverService.Builder.class).spliterator(), false).filter(b -> b instanceof EdgeDriverService.Builder).map(b -> (EdgeDriverService.Builder)((Object)b)).filter(b -> b.isLegacy() == isLegacy).findFirst().orElseThrow(WebDriverException::new);
        if (isLegacy) {
            return new DriverCommandExecutor(builder.build());
        }
        return new ChromiumDriverCommandExecutor(builder.build());
    }
}

