/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.Connection;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;

public class SeleniumCdpConnection
extends Connection {
    private SeleniumCdpConnection(HttpClient client, String url) {
        super(client, url);
    }

    public static Optional<Connection> create(WebDriver driver) {
        if (!(driver instanceof HasCapabilities)) {
            throw new IllegalStateException("Given webdriver instance must have capabilities");
        }
        return SeleniumCdpConnection.create(((HasCapabilities)driver).getCapabilities());
    }

    public static Optional<Connection> create(Capabilities capabilities) {
        Require.nonNull((String)"Capabilities", (Object)capabilities);
        return SeleniumCdpConnection.create(HttpClient.Factory.createDefault(), capabilities);
    }

    public static Optional<Connection> create(HttpClient.Factory clientFactory, Capabilities capabilities) {
        Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        Require.nonNull((String)"Capabilities", (Object)capabilities);
        return SeleniumCdpConnection.getCdpUri(capabilities).map(uri -> new SeleniumCdpConnection(clientFactory.createClient(ClientConfig.defaultConfig().baseUri(uri)), uri.toString()));
    }

    public static Optional<URI> getCdpUri(Capabilities capabilities) {
        Object options = capabilities.getCapability("se:options");
        if (!(options instanceof Map)) {
            return Optional.empty();
        }
        Object cdp = ((Map)options).get("cdp");
        if (!(cdp instanceof String)) {
            return Optional.empty();
        }
        try {
            return Optional.of(new URI((String)cdp));
        }
        catch (URISyntaxException e) {
            return Optional.empty();
        }
    }
}

