/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.runtime.model;

import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Optional;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;
import org.openqa.selenium.devtools.runtime.model.UnserializableValue;
import org.openqa.selenium.json.JsonInput;

public class CallArgument {
    private final Optional<Map<String, Object>> value;
    private final Optional<UnserializableValue> unserializableValue;
    private final Optional<RemoteObjectId> objectId;

    public CallArgument(Optional<Map<String, Object>> value, Optional<UnserializableValue> unserializableValue, Optional<RemoteObjectId> objectId) {
        this.value = value;
        this.unserializableValue = unserializableValue;
        this.objectId = objectId;
    }

    public Optional<Map<String, Object>> getValue() {
        return this.value;
    }

    public Optional<UnserializableValue> getUnserializableValue() {
        return this.unserializableValue;
    }

    public Optional<RemoteObjectId> getObjectId() {
        return this.objectId;
    }

    private static CallArgument fromJson(JsonInput input) {
        Optional<Map<String, Object>> value = Optional.empty();
        Optional<UnserializableValue> unserializableValue = Optional.empty();
        Optional<RemoteObjectId> objectId = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "value": {
                    value = Optional.ofNullable((Map)input.read(new TypeToken<Map<String, Object>>(){}.getType()));
                    continue block10;
                }
                case "unserializableValue": {
                    unserializableValue = Optional.ofNullable((UnserializableValue)input.read(UnserializableValue.class));
                    continue block10;
                }
                case "objectId": {
                    objectId = Optional.ofNullable((RemoteObjectId)input.read(RemoteObjectId.class));
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CallArgument(value, unserializableValue, objectId);
    }
}

