/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.overlay;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.dom.model.NodeId;
import org.openqa.selenium.devtools.dom.model.Quad;
import org.openqa.selenium.devtools.dom.model.RGBA;
import org.openqa.selenium.devtools.overlay.model.ColorFormat;
import org.openqa.selenium.devtools.overlay.model.HighlightConfig;
import org.openqa.selenium.devtools.overlay.model.HingeConfig;
import org.openqa.selenium.devtools.overlay.model.InspectMode;
import org.openqa.selenium.devtools.page.model.FrameId;
import org.openqa.selenium.devtools.page.model.Viewport;
import org.openqa.selenium.devtools.runtime.model.RemoteObjectId;

@Beta
public class Overlay {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.disable", (Map<String, Object>)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.enable", (Map<String, Object>)params.build());
    }

    public static Command<Map<String, Object>> getHighlightObjectForTest(NodeId nodeId, Optional<Boolean> includeDistance, Optional<Boolean> includeStyle, Optional<ColorFormat> colorFormat) {
        Objects.requireNonNull(nodeId, "nodeId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"nodeId", (Object)nodeId);
        includeDistance.ifPresent(p -> params.put((Object)"includeDistance", p));
        includeStyle.ifPresent(p -> params.put((Object)"includeStyle", p));
        colorFormat.ifPresent(p -> params.put((Object)"colorFormat", (Object)p));
        return new Command<Map<String, Object>>("Overlay.getHighlightObjectForTest", (Map<String, Object>)params.build(), ConverterFunctions.map("highlight", new TypeToken<Map<String, Object>>(){}.getType()));
    }

    public static Command<Void> hideHighlight() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command<Void>("Overlay.hideHighlight", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightFrame(FrameId frameId, Optional<RGBA> contentColor, Optional<RGBA> contentOutlineColor) {
        Objects.requireNonNull(frameId, "frameId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"frameId", (Object)frameId);
        contentColor.ifPresent(p -> params.put((Object)"contentColor", p));
        contentOutlineColor.ifPresent(p -> params.put((Object)"contentOutlineColor", p));
        return new Command<Void>("Overlay.highlightFrame", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightNode(HighlightConfig highlightConfig, Optional<NodeId> nodeId, Optional<BackendNodeId> backendNodeId, Optional<RemoteObjectId> objectId, Optional<String> selector) {
        Objects.requireNonNull(highlightConfig, "highlightConfig is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"highlightConfig", (Object)highlightConfig);
        nodeId.ifPresent(p -> params.put((Object)"nodeId", p));
        backendNodeId.ifPresent(p -> params.put((Object)"backendNodeId", p));
        objectId.ifPresent(p -> params.put((Object)"objectId", p));
        selector.ifPresent(p -> params.put((Object)"selector", p));
        return new Command<Void>("Overlay.highlightNode", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightQuad(Quad quad, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(quad, "quad is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"quad", (Object)quad);
        color.ifPresent(p -> params.put((Object)"color", p));
        outlineColor.ifPresent(p -> params.put((Object)"outlineColor", p));
        return new Command<Void>("Overlay.highlightQuad", (Map<String, Object>)params.build());
    }

    public static Command<Void> highlightRect(Integer x, Integer y, Integer width, Integer height, Optional<RGBA> color, Optional<RGBA> outlineColor) {
        Objects.requireNonNull(x, "x is required");
        Objects.requireNonNull(y, "y is required");
        Objects.requireNonNull(width, "width is required");
        Objects.requireNonNull(height, "height is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"x", (Object)x);
        params.put((Object)"y", (Object)y);
        params.put((Object)"width", (Object)width);
        params.put((Object)"height", (Object)height);
        color.ifPresent(p -> params.put((Object)"color", p));
        outlineColor.ifPresent(p -> params.put((Object)"outlineColor", p));
        return new Command<Void>("Overlay.highlightRect", (Map<String, Object>)params.build());
    }

    public static Command<Void> setInspectMode(InspectMode mode, Optional<HighlightConfig> highlightConfig) {
        Objects.requireNonNull(mode, "mode is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"mode", (Object)mode);
        highlightConfig.ifPresent(p -> params.put((Object)"highlightConfig", p));
        return new Command<Void>("Overlay.setInspectMode", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowAdHighlights(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowAdHighlights", (Map<String, Object>)params.build());
    }

    public static Command<Void> setPausedInDebuggerMessage(Optional<String> message) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        message.ifPresent(p -> params.put((Object)"message", p));
        return new Command<Void>("Overlay.setPausedInDebuggerMessage", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowDebugBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowDebugBorders", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowFPSCounter(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowFPSCounter", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowPaintRects(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"result", (Object)result);
        return new Command<Void>("Overlay.setShowPaintRects", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowLayoutShiftRegions(Boolean result) {
        Objects.requireNonNull(result, "result is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"result", (Object)result);
        return new Command<Void>("Overlay.setShowLayoutShiftRegions", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowScrollBottleneckRects(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowScrollBottleneckRects", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowHitTestBorders(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowHitTestBorders", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowViewportSizeOnResize(Boolean show) {
        Objects.requireNonNull(show, "show is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"show", (Object)show);
        return new Command<Void>("Overlay.setShowViewportSizeOnResize", (Map<String, Object>)params.build());
    }

    public static Command<Void> setShowHinge(Optional<HingeConfig> hingeConfig) {
        ImmutableMap.Builder params = ImmutableMap.builder();
        hingeConfig.ifPresent(p -> params.put((Object)"hingeConfig", p));
        return new Command<Void>("Overlay.setShowHinge", (Map<String, Object>)params.build());
    }

    public static Event<BackendNodeId> inspectNodeRequested() {
        return new Event<BackendNodeId>("Overlay.inspectNodeRequested", ConverterFunctions.map("backendNodeId", BackendNodeId.class));
    }

    public static Event<NodeId> nodeHighlightRequested() {
        return new Event<NodeId>("Overlay.nodeHighlightRequested", ConverterFunctions.map("nodeId", NodeId.class));
    }

    public static Event<Viewport> screenshotRequested() {
        return new Event<Viewport>("Overlay.screenshotRequested", ConverterFunctions.map("viewport", Viewport.class));
    }

    public static Event<Void> inspectModeCanceled() {
        return new Event<Void>("Overlay.inspectModeCanceled", input -> null);
    }
}

