/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.backgroundservice;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.backgroundservice.model.BackgroundServiceEvent;
import org.openqa.selenium.devtools.backgroundservice.model.RecordingStateChanged;
import org.openqa.selenium.devtools.backgroundservice.model.ServiceName;

@Beta
public class BackgroundService {
    public static Command<Void> startObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command<Void>("BackgroundService.startObserving", (Map<String, Object>)params.build());
    }

    public static Command<Void> stopObserving(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command<Void>("BackgroundService.stopObserving", (Map<String, Object>)params.build());
    }

    public static Command<Void> setRecording(Boolean shouldRecord, ServiceName service) {
        Objects.requireNonNull(shouldRecord, "shouldRecord is required");
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"shouldRecord", (Object)shouldRecord);
        params.put((Object)"service", (Object)service);
        return new Command<Void>("BackgroundService.setRecording", (Map<String, Object>)params.build());
    }

    public static Command<Void> clearEvents(ServiceName service) {
        Objects.requireNonNull(service, "service is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"service", (Object)service);
        return new Command<Void>("BackgroundService.clearEvents", (Map<String, Object>)params.build());
    }

    public static Event<RecordingStateChanged> recordingStateChanged() {
        return new Event<RecordingStateChanged>("BackgroundService.recordingStateChanged", input -> (RecordingStateChanged)input.read(RecordingStateChanged.class));
    }

    public static Event<BackgroundServiceEvent> backgroundServiceEventReceived() {
        return new Event<BackgroundServiceEvent>("BackgroundService.backgroundServiceEventReceived", ConverterFunctions.map("backgroundServiceEvent", BackgroundServiceEvent.class));
    }
}

