/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.webauthn.model;

import java.util.Objects;
import org.openqa.selenium.json.JsonInput;

public class Credential {
    private final String credentialId;
    private final Boolean isResidentCredential;
    private final String rpId;
    private final String privateKey;
    private final String userHandle;
    private final Integer signCount;

    public Credential(String credentialId, Boolean isResidentCredential, String rpId, String privateKey, String userHandle, Integer signCount) {
        this.credentialId = Objects.requireNonNull(credentialId, "credentialId is required");
        this.isResidentCredential = Objects.requireNonNull(isResidentCredential, "isResidentCredential is required");
        this.rpId = rpId;
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey is required");
        this.userHandle = userHandle;
        this.signCount = Objects.requireNonNull(signCount, "signCount is required");
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public Boolean getIsResidentCredential() {
        return this.isResidentCredential;
    }

    public String getRpId() {
        return this.rpId;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public String getUserHandle() {
        return this.userHandle;
    }

    public Integer getSignCount() {
        return this.signCount;
    }

    private static Credential fromJson(JsonInput input) {
        String credentialId = null;
        Boolean isResidentCredential = null;
        String rpId = null;
        String privateKey = null;
        String userHandle = null;
        Integer signCount = null;
        input.beginObject();
        block16: while (input.hasNext()) {
            switch (input.nextName()) {
                case "credentialId": {
                    credentialId = input.nextString();
                    continue block16;
                }
                case "isResidentCredential": {
                    isResidentCredential = input.nextBoolean();
                    continue block16;
                }
                case "rpId": {
                    rpId = input.nextString();
                    continue block16;
                }
                case "privateKey": {
                    privateKey = input.nextString();
                    continue block16;
                }
                case "userHandle": {
                    userHandle = input.nextString();
                    continue block16;
                }
                case "signCount": {
                    signCount = input.nextNumber().intValue();
                    continue block16;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new Credential(credentialId, isResidentCredential, rpId, privateKey, userHandle, signCount);
    }
}

