/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeSignature {
    private final String label;
    private final String signature;
    private final String integrity;
    private final String certUrl;
    private final String certSha256;
    private final String validityUrl;
    private final Integer date;
    private final Integer expires;
    private final List<String> certificates;

    public SignedExchangeSignature(String label, String signature, String integrity, String certUrl, String certSha256, String validityUrl, Integer date, Integer expires, List<String> certificates) {
        this.label = Objects.requireNonNull(label, "label is required");
        this.signature = Objects.requireNonNull(signature, "signature is required");
        this.integrity = Objects.requireNonNull(integrity, "integrity is required");
        this.certUrl = certUrl;
        this.certSha256 = certSha256;
        this.validityUrl = Objects.requireNonNull(validityUrl, "validityUrl is required");
        this.date = Objects.requireNonNull(date, "date is required");
        this.expires = Objects.requireNonNull(expires, "expires is required");
        this.certificates = certificates;
    }

    public String getLabel() {
        return this.label;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getIntegrity() {
        return this.integrity;
    }

    public String getCertUrl() {
        return this.certUrl;
    }

    public String getCertSha256() {
        return this.certSha256;
    }

    public String getValidityUrl() {
        return this.validityUrl;
    }

    public Integer getDate() {
        return this.date;
    }

    public Integer getExpires() {
        return this.expires;
    }

    public List<String> getCertificates() {
        return this.certificates;
    }

    private static SignedExchangeSignature fromJson(JsonInput input) {
        String label = null;
        String signature = null;
        String integrity = null;
        String certUrl = null;
        String certSha256 = null;
        String validityUrl = null;
        Integer date = null;
        Integer expires = null;
        List certificates = null;
        input.beginObject();
        block22: while (input.hasNext()) {
            switch (input.nextName()) {
                case "label": {
                    label = input.nextString();
                    continue block22;
                }
                case "signature": {
                    signature = input.nextString();
                    continue block22;
                }
                case "integrity": {
                    integrity = input.nextString();
                    continue block22;
                }
                case "certUrl": {
                    certUrl = input.nextString();
                    continue block22;
                }
                case "certSha256": {
                    certSha256 = input.nextString();
                    continue block22;
                }
                case "validityUrl": {
                    validityUrl = input.nextString();
                    continue block22;
                }
                case "date": {
                    date = input.nextNumber().intValue();
                    continue block22;
                }
                case "expires": {
                    expires = input.nextNumber().intValue();
                    continue block22;
                }
                case "certificates": {
                    certificates = (List)input.read(new TypeToken<List<String>>(){}.getType());
                    continue block22;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeSignature(label, signature, integrity, certUrl, certSha256, validityUrl, date, expires, certificates);
    }
}

