/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.network.model;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.network.model.Response;
import org.openqa.selenium.devtools.network.model.SecurityDetails;
import org.openqa.selenium.devtools.network.model.SignedExchangeError;
import org.openqa.selenium.devtools.network.model.SignedExchangeHeader;
import org.openqa.selenium.json.JsonInput;

@Beta
public class SignedExchangeInfo {
    private final Response outerResponse;
    private final SignedExchangeHeader header;
    private final SecurityDetails securityDetails;
    private final List<SignedExchangeError> errors;

    public SignedExchangeInfo(Response outerResponse, SignedExchangeHeader header, SecurityDetails securityDetails, List<SignedExchangeError> errors) {
        this.outerResponse = Objects.requireNonNull(outerResponse, "outerResponse is required");
        this.header = header;
        this.securityDetails = securityDetails;
        this.errors = errors;
    }

    public Response getOuterResponse() {
        return this.outerResponse;
    }

    public SignedExchangeHeader getHeader() {
        return this.header;
    }

    public SecurityDetails getSecurityDetails() {
        return this.securityDetails;
    }

    public List<SignedExchangeError> getErrors() {
        return this.errors;
    }

    private static SignedExchangeInfo fromJson(JsonInput input) {
        Response outerResponse = null;
        SignedExchangeHeader header = null;
        SecurityDetails securityDetails = null;
        List errors = null;
        input.beginObject();
        block12: while (input.hasNext()) {
            switch (input.nextName()) {
                case "outerResponse": {
                    outerResponse = (Response)input.read(Response.class);
                    continue block12;
                }
                case "header": {
                    header = (SignedExchangeHeader)input.read(SignedExchangeHeader.class);
                    continue block12;
                }
                case "securityDetails": {
                    securityDetails = (SecurityDetails)input.read(SecurityDetails.class);
                    continue block12;
                }
                case "errors": {
                    errors = (List)input.read(new TypeToken<List<SignedExchangeError>>(){}.getType());
                    continue block12;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new SignedExchangeInfo(outerResponse, header, securityDetails, errors);
    }
}

